#include    "mbed.h"
#include    "PCA9955A.h"

BusOut      leds( LED4, LED3, LED2, LED1 );
DigitalOut  pin( p21 );
AnalogIn    ain( p20 );
AnalogOut   aout( p18 );

PCA9955A    led_driver( p28, p27, 0x02 );   // SDA, SCL, I2C_slave_sddress

Ticker  led_maintenance;
Ticker  sample_timing;

int     led_change  = 0;
int     sampling    = 0;


void    set_color( int v );
void    led_cntl();
void    ad_cntl();
int     peak_detect( float in );
void    init_setting( void );


int main()
{
    init_setting();

    led_maintenance.attach( &led_cntl, 0.02 );
    sample_timing.attach( &ad_cntl, 0.01 );

    while(1) {

        if ( sampling ) {
            sampling    = 0;
            led_change  = peak_detect( (float)ain );
        }
    }

}


int peak_detect( float in )
{
    static float    coef        = 26.4;
    static float    peak        = 0;
    static float    thresold    = 0.05;
    static int      shift;
    static int      count       = 0;
    int             rtn         = 0;

    pin =0;
    in      = (float)ain;

    if ( 0.06 < in ) {
        if ( 200 <= count ) {
            led_maintenance.attach( &led_cntl, 0.02 );
            init_setting();
        }
        count       = 0;

        if ( peak < in ) {
            if ( thresold < (in - peak) ) {
                thresold    = in - peak;
                rtn         = 1;
            }
            peak    = in;
        }
    } else {
        if ( 200 == count ) {
            led_maintenance.attach( NULL, 0.02 );

            init_setting();
            led_driver  = 0xEEEE;
            led_driver.set_all_intensity( (char)0xC7, true );
            led_driver.group_selector( 0x1111, 0x2222, 0x4444, 0x8888 );   //  channel assignment for groups
            led_driver.gradation_setting( 0 ,0xC0 ,0x8 ,0xD2 ,0xDE );
            led_driver.gradation_setting( 1 ,0xC0 ,0x9 ,0xC4 ,0xC7 );
            led_driver.gradation_setting( 2 ,0xC0 ,0x9 ,0xC4 ,0xC7 );
            led_driver.gradation_setting( 3 ,0xC0 ,0x9 ,0xC4 ,0xC7 );
            led_driver.gradation_start( 1, CONTINUOUS );

        } else if ( 300 == count ) {
            led_driver.gradation_start( 2, CONTINUOUS );
        } else if ( 400 == count ) {
            led_driver.gradation_start( 3, CONTINUOUS );
        } else if ( 500 == count ) {
            //led_driver.gradation_start( 3, CONTINUOUS );
        }
        count++;
    }

    shift  = (int)(coef * peak);
    leds    = 0x1 << shift;
    peak    *= 0.97;
    thresold*= (thresold < 0.07) ? 0.07 : thresold * 0.9;
    pin =1;
    aout    = peak;

    if ( shift > 2 ) {
        //led_change  = 1;
    }

    return ( rtn );
}

void ad_cntl()
{
    sampling    = 1;
}


void led_cntl()
{
    static int      count       = 0;
    static float    intensity   = 1.0;

    if ( led_change ) {
        set_color( count++ & 0x3 );
        led_change  = 0;
        intensity   = 1.0;
    }

    led_driver.set_all_intensity( (char)(intensity * (float)0xFF) );

    intensity   *= 0.90;
}

void set_color( int v )
{
    v   = 0x1 << v;
    led_driver  = (v << 12) | (v << 8) | (v << 4) | v;
}


void init_setting( void )
{
    led_driver  = 0xFFFF;
    led_driver.set_all_intensity( 0xFF );
    led_driver.set_all_intensity( 0x40, true );
    led_driver.group_selector( 0x0000, 0x0000, 0x0000, 0x0000 );   //  all channels are in normal control
}

