/**
 *  PCA9546A library "Hello world" sample
 *
 *  @author  Tedd OKANO
 *  @version 0.1
 *  @date    Feb-2015
 *
 *  PCA9546A: an I2C bus switch control library
 *
 *  The PCA9546A is a quad bidirectional translating switch controlled
 *  via the I2C-bus. The SCL/SDA upstream pair fans out to four downstream
 *  pairs, or channels. Any individual SCx/SDx channel or combination of
 *  channels can be selected, determined by the contents of the programmable
 *  control register.
 *
 *  For more information about PCA9546A:
 *    http://www.nxp.com/documents/data_sheet/PCA9546A.pdf
 *
 */

#include "mbed.h"
#include "LM75B.h"
#include "PCA9546A.h"

PCA9546A    i2c_sw( p28, p27, 0xE0 );

int main()
{
    //  all PCA9546A's downstream ports are OFF after power-up and hardware-reset
    
    i2c_sw.on( 0 );     //  turn-ON  the channel 0

    LM75B   tmp0( p28, p27 );   //  making instance after a branch of I2C bus (which is connecting the LM75B) enabled

    i2c_sw.off( 0 );    //  turn-OFF the channel 0
    i2c_sw.on( 1 );     //  turn-ON  the channel 1

    LM75B   tmp1( p28, p27 );   //  making instance after a branch of I2C bus (which is connecting the LM75B) enabled

    while(1) {
        
        i2c_sw.off( 1 );    //  turn-OFF the channel 1
        i2c_sw.on( 0 );     //  turn-ON  the channel 0
        printf( "%.3f\r\n", tmp0.read() );

        i2c_sw.off( 0 );    //  turn-OFF the channel 0
        i2c_sw.on( 1 );     //  turn-ON  the channel 1
        printf( "%.3f\r\n", tmp1.read() );

        wait( 1.0 );
    }
}
