/*
 *  PCF2127A (Integrated RTC, TCXO and quartz crystal) demo
 *
 *  PCF2127A is a "real time clock (RTC)" module which is including a Xtal and TCXO 
 *  http://www.nxp.com/pip/PCF2127A_2.html
 *
 *  This is a just simple operation sample of the PCF2127A.
 *  In this sample, the PCF2127A is interfaced by I2C through pin9 and 10 of mbed. 
 *  And also the mbed-pin8 is connected to RTC's /INT pin. 
 *  The RTC chip is set to generate periodical interrupt in every seconds. 
 *  This interrupt triggers the update of the terminal and LCD screen. 
 *  
 *  RTC initializing part is ported from...
 *    http://mbed.org/users/roen/notebook/real-time/
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.0    05-Jun-2010     (a) 1st release
 *  revision 1.1    05-Jun-2010     (a) class name changed
 *                              
 */

#include "mbed.h"
#include "TextLCD.h"
#include "NXP_PCF2127A.h"

TextLCD         lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3
NXP_PCF2127A    rtc( p9, p10 );
InterruptIn     intr( p8 );
BusOut          leds( LED4, LED3, LED2, LED1 );

void time_intr( void );
void led_ctrl( void );

int main() {
    printf( "----------------- PCF2127 demo started.\r\n" );

    leds    = 1;

    if ( rtc.is_init_required() ) {
        lcd.locate( 0, 0 );
        lcd.printf( "please set time from terminal" );
        
        rtc.set_time();
        
        lcd.cls();
    }

    intr.fall( &time_intr );

    while ( 1 )
        ;
}


void time_intr( void ) {
    struct tm   dt, *dtp;
    time_t      t;
    char        s[ 30 ];
    dtp = &dt;

    rtc.clear_intr();

    t       = rtc.time( NULL );
    dtp     = localtime( &t );

    strftime( s, 30, "%H:%M:%S, %Y/%b/%d %a", dtp );
    printf( "%s\r\n", s );

    strftime( s, 20, "%H:%M:%S PCF2127", dtp );
    lcd.locate( 0, 0 );
    lcd.printf( "%s", s );

    strftime( s, 20, "%Y/%b/%d(%a)", dtp );
    lcd.locate( 0, 1 );
    lcd.printf( "%s", s );
    
    led_ctrl();
}


void led_ctrl( void )
{
    static char direction   = true;
    
    leds        = direction ? leds << 1 : leds >> 1;
    direction   = (leds & 0x9) ? !direction : direction;
}

