/*
 *  I2C digital temperature sensor "LM75B" demo
 *
 *  LM75B is an I2C based digital temperature sensor
 *  http://www.nxp.com/pip/LM75B_2.html
 *
 *  This is a library to operate this chip easy.
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.0    16-Jan-2010     (a) 1st release
 *  revision 1.1    23-Jan-2010     (a) class name has been changed from LM75B to NXP_LM75B
 *                                  (b) copyright notice added
 *  revision 2.0    05-Jun-2010     (a) demo modified to make the library simple
 *
 */

#include "mbed.h"
#include "TextLCD.h"
#include "NXP_LM75B.h"

NXP_LM75B  temp_sensor( p9, p10, 0x9E );           // sda, scl, I2C_address(0x9E)
TextLCD    lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3

int main() {

    lcd.locate( 0, 1 );
    lcd.printf( " NXP LM75B demo" );

    while ( 1 ) {
        lcd.locate( 0, 0 );
        lcd.printf( "%4.1f (deg-C)", (float)temp_sensor );

        wait( 1 );
    }
}

