/*
 *  I2C digital temperature sensor "LM75B" library
 *
 *  LM75B is an I2C based digital temperature sensor
 *  http://www.nxp.com/pip/LM75B_2.html
 *
 *  This is a library to operate this chip easy.
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.0    16-Jan-2010     (a) 1st release
 *  revision 1.1    23-Jan-2010     (a) class name has been changed from LM75B to NXP_LM75B
 *                                  (b) copyright notice added
 *  revision 2.0    05-Jun-2010     (a) demo modified to make the library simple
 */

#ifndef        MBED_NXP_LM75B
#define        MBED_NXP_LM75B


#include    "mbed.h"


//  LM75B IIC address
const char    LM75B_base_addr = 0x90;

//  LM75B registers
const char    Conf            = 0x01;
const char    Temp            = 0x00;
const char    Tos             = 0x03;
const char    Thyst           = 0x02;


class NXP_LM75B  {
public:

    NXP_LM75B(    PinName sda, 
                PinName sdl, 
                char dev_address = LM75B_base_addr, 
                char vConf = 0x00, 
                short vTos  = 0x5000, 
                short vThyst = 0x4B00 
             ) 
             : i2c( sda, sdl ), device_address( dev_address ) 
    {
    
        char    data[ 3 ];

        data[ 0 ]    = Conf;
        data[ 1 ]    = vConf;

        if ( i2c.write( device_address, data, 2 ) )
            ;

        data[ 0 ]    = Tos;
        data[ 1 ]    = (char)(vTos >> 8);
        data[ 2 ]    = (char)vTos;

        if ( i2c.write( device_address, data, 3 ) )
            ;

        data[ 0 ]    = Thyst;
        data[ 1 ]    = (char)(vThyst >> 8);
        data[ 2 ]    = (char)vThyst;

        if ( i2c.write( device_address, data, 3 ) )
            ;
    }

    int temp_short( void ) {
        char    data[ 2 ];

        data[ 0 ]    = 0;

        if ( i2c.write( device_address, data, 1 ) )
            ;

        if ( i2c.read( device_address, data, 2 ) )
            ;

        return ( (((short)data[ 0 ]) << 8 | data[ 1 ]) >> 5 );
    }

    float temp( void ) {
        return ( (float)(temp_short()) / 8.0 );
    }

    operator float( void ) {
        return( temp() );
    }
    
private:
    I2C     i2c;
    char    device_address;

}
;

#endif