/*
 *  I2C digital temperature sensor "LM75B" test
 *
 *  LM75B is an I2C based digital temperature sensor
 *  http://www.nxp.com/pip/LM75B_2.html
 *
 *   This program is Expecting to use the pins 9 and 10 for I2C bus
 *   these pins should be pulled-up properly.
 *
 *   The temperature read out will be shown on terminal on the PC screen.
 *
 *   In this demo code, two LM75B devices can be driven.
 *   These two devices should have different I2C address setting
 *   using its address pins (LM75B's A0 to A2 (pins 5 to 7)).
 *   One LM75B should have all those pins tied to GND.
 *   And another should have the pin A0(pin7) pulled-up.
 *
 *   From the software, those devices can be accessed by I2C addresses
 *   "0x90" and "0x92".
 *   It will not be as "0x90" and "0x91" because the address has
 *   7 bit only and stuffed to left. So the "A0" setting become 0xX2.
 *   The LSB does not care because it will be set by I2C libraly when
 *   it transfer the data for read and write.
 *
 *   This code is new version that can handle the LM75B are the objects.
 *
 *  Copyright (c) 2010 Tedd OKANO
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.0  16-Jan-2010   a. 1st release
 *  revision 1.1  23-Jan-2010   a. class name has been changed from LM75B to TempSensor_LM75B
 *                              b. class name has been changed from lcd_SB1602E to TextLCD_SB1602E
 *                              c. copyright notice added
 */

#include "mbed.h"
#include "TempSensor_LM75B.h"
#include "TextLCD_SB1602E.h"

Serial       pc(USBTX, USBRX); // tx, rx

I2C          i2c( p9, p10 );        // sda, scl

TempSensor_LM75B    thermo_sensor_0( &i2c );        //  sensor_0 using with default I2C address "0x90".
TempSensor_LM75B    thermo_sensor_1( &i2c, 0x92 );  //  sensor_1 gaved I2C address since that address pin A0=HIGH.
TextLCD_SB1602E        lcd( &i2c );

int main() {
    float  t0;
    float  t1;
    int    i    = 0;

    while (1) {
        t0    = thermo_sensor_0;
        t1    = thermo_sensor_1;

        pc.printf( "  (%d)  sensor_0= %4.1f\xDF,  sensor_1= %4.1f(degree-C)\n", i++, t0, t1 );

        lcd.printf( 0, "sensor0   %4.1f%cC\r", t0, 0xDF );
        lcd.printf( 1, "sensor1   %4.1f%cC\r", t1, 0xDF );

        wait( 1 );
    }
}

