#include "MjGP2Y0E03.h"

#define IMAGE_SENSOR_DATA_NUMBER    (220)

//namespace matsujirushi {

MjGP2Y0E03::MjGP2Y0E03(I2C* i2c, uint8_t address)
{
    this->i2c = i2c;
    this->address = address;
}

uint16_t MjGP2Y0E03::getDistance()
{
    uint8_t data[2];

    read(0x5e, data, sizeof (data));   // Distance

    return ((uint16_t)data[0] << 4) + (data[1] & 0x0f);
}

float MjGP2Y0E03::rd()
{
    return ( (float)getDistance() / 4095.0 );
}

bool MjGP2Y0E03::getImageSensorData(uint32_t *data, size_t dataSize, size_t *dataSizeActual)
{
    if (dataSize < sizeof (uint32_t) * 220) {
        if (dataSizeActual != NULL) {
            *dataSizeActual = sizeof (uint32_t) * 220;
        }
        return false;
    }

//    write(0xef, 0x00);  // Bank Select = Bank0
//    write(0xec, 0xff);  // Clock Select = manual clock
//    wait_ms(80);

    write(0x03, 0x00);  // Hold Bit = Hold
    wait_ms(80);

    write(0x4c, 0x10);  // SRAM Access = Access SRAM
    wait_ms(80);

    uint8_t dataL[IMAGE_SENSOR_DATA_NUMBER];
    write(0x90, 0x10);  // Read out Image Sensor Data = Low Level
    read(0x00, dataL, sizeof (dataL));

    uint8_t dataM[IMAGE_SENSOR_DATA_NUMBER];
    write(0x90, 0x11);  // Read out Image Sensor Data = Middle Level
    read(0x00, dataM, sizeof (dataM));

    uint8_t dataH[IMAGE_SENSOR_DATA_NUMBER];
    write(0x90, 0x12);  // Read out Image Sensor Data = High Level
    read(0x00, dataH, sizeof (dataH));

    write(0x90, 0x00);  // Read out Image Sensor Data = Disable
    write(0x03, 0x01);  // Hold Bit = Device enable normally

    for (int i = 0; i < IMAGE_SENSOR_DATA_NUMBER; i++) {
        *data++ = dataH[i] * 65536 + dataM[i] * 256 + dataL[i];
    }
    if (dataSizeActual != NULL) {
        *dataSizeActual = sizeof (uint32_t) * 220;
    }

    return true;
}

void MjGP2Y0E03::read(uint8_t regAddress, uint8_t *data, size_t dataSize)
{
    i2c->write(address, (char*)&regAddress, 1, true);
    i2c->read(address, (char*)data, dataSize);
}

void MjGP2Y0E03::write(uint8_t regAddress, uint8_t data)
{
    char buffer[] = { regAddress, data, };
    i2c->write(address, buffer, sizeof (buffer));
}

//} // namespace matsujirushi


