#include "mbed.h"
#include "MARMEX_OB_oled.h"
#include "MARY_CAMERA.h"

#if defined( TARGET_MBED_LPC1768 ) || defined( TARGET_LPC11U24_401 ) || defined( TARGET_LPC11XX )
MARMEX_OB_oled  oled1( p5, p7,  p20, p16, p15 ); // mosi, sclk, cs, rst, power_control     -- maple-mini-type-b-slot1
MARY_CAMERA     camera( p5, p6, p7, p22, p26, p28, p27 ); // mosi, miso, sclk, cs, reset, I2C_SDA, I2C_SCL
#endif

#if defined( TARGET_LPC11U35_401 )
MARMEX_OB_oled  oled1( P0_9, P0_10,  P0_16, P0_12, P0_11 ); // mosi, sclk, cs, rst, power_control     -- maple-mini-type-b-slot1
MARY_CAMERA     camera( P0_9, P0_8, P0_10, P0_2, P1_15, P0_5, P0_4 ); // mosi, miso, sclk, cs, reset, I2C_SDA, I2C_SCL
#endif

BusOut          led( LED4, LED3, LED2, LED1 );

void test_camera_QCIF_video_with_colorbar( void );
void test_camera_resolution_change( void );

void copy_image_to_oled( void );
void line_mirroring( short *buf );
void save_still_image( char *file_name );
void oled_test_screen( void );
void capture_to_bmp( void );

//#define     SAVE_EACH_SIZES_OF_STILL_IMAGE
int read_order_change   = 0;

int main()
{
    printf( "\r\n\r\nMARY-CAMERA test program\r\n\r\n" );

    led    = 0x3;

    oled1.cls();
    oled_test_screen();

#if defined( TARGET_MBED_LPC1768 )

#ifdef  SAVE_EACH_SIZES_OF_STILL_IMAGE
    led    = 0x1;
    camera.resolution( MARY_CAMERA::QCIF );
    save_still_image( "i_qcif.bmp" );

    led    = 0x2;
    camera.resolution( MARY_CAMERA::QQVGA );
    save_still_image( "i_qqvga.bmp" );

    led    = 0x4;
    camera.resolution( MARY_CAMERA::QVGA );
    save_still_image( "i_qvga.bmp" );

    led    = 0x8;
    camera.resolution( MARY_CAMERA::VGA );
    save_still_image( "i_vga.bmp" );

    camera.resolution( MARY_CAMERA::QCIF );
#endif

#endif
    printf( "  camera operation started\r\n" );
    printf( "    hit key [c] for saving data into BMP\r\n" );
    printf( "    hit key [o] to change data reading order\r\n" );
    printf( "    hit key [1], [2], [3] or [4] to change resolution QCIF, QQVGA, QVGA, VGA\r\n" );

    test_camera_QCIF_video_with_colorbar();   //  doesn't return
//    test_camera_resolution_change();   //  doesn't return
}

Serial      pc(USBTX, USBRX);    // tx, rx

void test_camera_QCIF_video_with_colorbar( void )
{
    while ( 1 ) {
        
        if ( pc.readable() ) {
            switch ( pc.getc() ) {
                case 'c' :
                    capture_to_bmp();
                    printf( "  [c] : capture started\r\n" );
                    break;
                case 'o' :
                    read_order_change   = read_order_change ? 0 : 1;
                    printf( "  [o] read order change : %s\r\n", read_order_change ? "ENABLED" : "DISABLED" );
                    break;
                case '1' :
                    printf( "  [1] resolution change : QCIF\r\n" );
                    camera.init( MARY_CAMERA::QCIF );
                    break;
                case '2' :
                    printf( "  [2] resolution change : QQVGA\r\n" );
                    camera.init( MARY_CAMERA::QQVGA );
                    break;
                case '3' :
                    printf( "  [3] resolution change : QVGA\r\n" );
                    camera.init( MARY_CAMERA::QVGA );
                    break;
                case '4' :
                    printf( "  [4] resolution change : VGA\r\n" );
                    camera.init( MARY_CAMERA::VGA );
                    break;
            }
        }


        led    = 0x1;
        copy_image_to_oled();
//        camera.colorbar( ((count++ >> 2) & 0x1) ? MARY_CAMERA::ON : MARY_CAMERA::OFF );
        led    = 0x2;
    }
}


void test_camera_resolution_change( void )
{
    int     count   = (3 << 3);
    int     setting;

    while ( 1 ) {

        if ( !(count & 0x7) ) {
            setting     = (count >> 3) & 0x3;
            camera.init( (MARY_CAMERA::CameraResolution)(setting + 1) );
            led    = 0x1 << setting;
        }

        count++;

        copy_image_to_oled();
    }
}


void copy_image_to_oled( void )
{
    short   buf[ MARMEX_OB_oled::WIDTH ];

    camera.open_transfer();

    for ( int line = 0; line < MARMEX_OB_oled::HEIGHT; line++  ) {
        camera.transfer_a_line( buf, line + (camera.vertical_size() - (int)MARMEX_OB_oled::HEIGHT) / 2, (camera.horizontal_size() - (int)MARMEX_OB_oled::WIDTH ) / 2, MARMEX_OB_oled::WIDTH );
        line_mirroring( buf );
        oled1.blit565( 0, line, MARMEX_OB_oled::WIDTH, 1, buf );
    }

    camera.close_transfer();
}


void line_mirroring( short *buf )
{
    short   tmp;

    for ( int i = 0; i < (MARMEX_OB_oled::WIDTH / 2); i++ ) {
        tmp         = buf[ i ];
        buf[ i ]    = buf[ (MARMEX_OB_oled::WIDTH - 1) - i ];
        buf[ (MARMEX_OB_oled::WIDTH - 1) - i ]  = tmp;
    }
}


void oled_test_screen( void )
{
    oled1.background( 0x000000 );
    oled1.cls();

    int colorbar_width  = MARMEX_OB_oled::WIDTH / 8;

    for ( int i = 0; i < 8; i++ )
        oled1.fill( colorbar_width * i, 0, colorbar_width, MARMEX_OB_oled::HEIGHT, ((i & 0x4) ? 0xFF0000 : 0x000000) | ((i & 0x2) ? 0x00FF00 : 0x000000) | ((i & 0x1) ? 0x0000FF : 0x000000) );

    oled1.fill(  50,  50,  64,  64, 0xCCCCCC );;

    oled1.locate( 0, 2 );
    oled1.printf( "MaryCemara test" );
    oled1.locate( 0, 3 );
    oled1.printf( "%s", (MARY_CAMERA::NO_ERROR == camera.ready()) ? "Camera is ready" : "No Camera found" );
    oled1.locate( 0, 4 );
    oled1.printf( "%s", "saving into BMP" );
    oled1.locate( 0, 5 );
    oled1.printf( "%d", camera.horizontal_size() );
    oled1.locate( 0, 6 );
    oled1.printf( "%d", camera.vertical_size() );


    for (int i = 0; i < MARMEX_OB_oled::WIDTH; i++ )
        oled1.pixel( i, 80 + sin( (float)i / 5.0 ) * 10, 0x000000 );
}


#include    "bmp_handler.h"

void save_still_image( char *file_name )
{
    short   buf[ camera.horizontal_size() ];

    if ( open_BMP( file_name, camera.horizontal_size(), camera.vertical_size() ) )
        return;

    camera.open_transfer();

    for ( int line = (camera.vertical_size() - 1); 0 <= line; line--  ) {
        camera.transfer_a_line( buf, line, 0, camera.horizontal_size() );
        write_BMP( buf, camera.horizontal_size() );
    }
    camera.close_transfer();

    close_BMP();
}

void capture_to_bmp( void )
{
    short   buf[ camera.horizontal_size() ];
    camera.open_transfer();

#if 0
    for ( int line = 0; line < MARMEX_OB_oled::HEIGHT; line++  ) {
        camera.transfer_a_line( buf, line + (camera.vertical_size() - (int)MARMEX_OB_oled::HEIGHT) / 2, (camera.horizontal_size() - (int)MARMEX_OB_oled::WIDTH ) / 2, MARMEX_OB_oled::WIDTH );
        line_mirroring( buf );
        oled1.blit565( 0, line, MARMEX_OB_oled::WIDTH, 1, buf );
    }
#endif

    if ( open_BMP( "RGB.bmp", camera.horizontal_size(), camera.vertical_size() ) )
        return;

    for ( int line = (camera.vertical_size() - 1); 0 <= line; line--  ) {
        camera.transfer_a_line( buf, line, 0, camera.horizontal_size() );
        write_BMP( buf, camera.horizontal_size(), 0x7 );
    }

    close_BMP();

#if 0

    if ( open_BMP( "R.bmp", camera.horizontal_size(), camera.vertical_size() ) )
        return;

    for ( int line = (camera.vertical_size() - 1); 0 <= line; line--  ) {
        camera.transfer_a_line( buf, line, 0, camera.horizontal_size() );
        write_BMP( buf, camera.horizontal_size(), 0x4 );
    }

    close_BMP();


    if ( open_BMP( "G.bmp", camera.horizontal_size(), camera.vertical_size() ) )
        return;

    for ( int line = (camera.vertical_size() - 1); 0 <= line; line--  ) {
        camera.transfer_a_line( buf, line, 0, camera.horizontal_size() );
        write_BMP( buf, camera.horizontal_size(), 0x2 );
    }

    close_BMP();


    if ( open_BMP( "B.bmp", camera.horizontal_size(), camera.vertical_size() ) )
        return;

    for ( int line = (camera.vertical_size() - 1); 0 <= line; line--  ) {
        camera.transfer_a_line( buf, line, 0, camera.horizontal_size() );
        write_BMP( buf, camera.horizontal_size(), 0x1 );
    }

    close_BMP();

#endif
    camera.close_transfer();
}
