/** mbeduino demo code (with 4x4x4 LED Cube shield)
 *
 *      This is a simple demo code of mbeduino + 4x4x4 LED Cube shield
 * 
 *      mbeduino              = http://mbed.org/users/okini3939/notebook/mbeduino/  (Japanese)
 *      4x4x4 LED Cube shield = http://www.galileo-7.com/?pid=20015630  (Japanese)
 *
 *      Released under the MIT License: http://mbed.org/license/mit
 *
 *      revision 0.5  14-Oct-2010   1st release
 */

#include "mbed.h"
#include "LED_Cube444.h"

#define     N_OF_DEMO_ROUTINES  8

LED_Cube444 cube;

int g_switch_demo    = 0;
int g_demo_selection = 0;

void animate( void );
void animate_single( void );
void animate_dual( void );
void random0( void );
void random1( void );
void fill( void );
void random_walker( void );
void single_turnon( int x, int y, int z );
void dummy_demo( void );
void demo_switching( void );

Ticker  t;

void (*func[ N_OF_DEMO_ROUTINES ])( void )    = {
    animate,
    animate_single,
    animate_dual,
    random0,
    random1,
    fill,
    random_walker,
    dummy_demo
};

int main() {
    t.attach( &demo_switching, 5 );

    while ( 1 ) {
        g_switch_demo   = 0;
        cube.clear();
        (*func[ g_demo_selection++ & (N_OF_DEMO_ROUTINES - 1)])();   //  Demo function call. The function selected by "g_select"

    }
}

void animate( void ) {
    U16     pattern[ 12 ]   = { 0x0800, 0x0080, 0x0008, 0x0004, 0x0002, 0x0001, 0x0010, 0x0100, 0x1000, 0x2000, 0x4000, 0x8000 };

    while ( !g_switch_demo ) {
        for ( int c = 0; c < CUBE_SIZE; c++ ) {
            for ( int i = 0; i < 12; i++ ) {
                cube.set_bits( c, pattern[ (i + 0) % 12 ] );
                wait( 0.02 );
            }
            cube.clear();
        }
    }
}

void animate_single( void ) {
    U16     pattern[ 12 ]   = { 0x8000, 0x4000, 0x2000, 0x1000, 0x0100, 0x0010, 0x0001, 0x0002, 0x0004, 0x0008, 0x0080, 0x0800 };

    while ( !g_switch_demo ) {
        for ( int i = 0; i < 12; i++ ) {
            cube.set_bits( 0, pattern[ (i + 0) % 12 ] );
            cube.set_bits( 1, pattern[ (i + 1) % 12 ] );
            cube.set_bits( 2, pattern[ (i + 2) % 12 ] );
            cube.set_bits( 3, pattern[ (i + 3) % 12 ] );
            wait( 0.05 );
        }
    }
}

void animate_dual( void ) {
//  U16     pattern[ 6 ]   = { 0x8421, 0x4422, 0x2244, 0x1248, 0x03C0, 0x0C30 };
    U16     pattern[ 6 ]   = { 0x8001, 0x4002, 0x2004, 0x1008, 0x0180, 0x0810 };

    while ( !g_switch_demo ) {
        for ( int i = 0; i < 6; i++ ) {
            cube.set_bits( 0, pattern[ (i + 0) % 6 ] );
            cube.set_bits( 1, pattern[ (i + 1) % 6 ] );
            cube.set_bits( 2, pattern[ (i + 2) % 6 ] );
            cube.set_bits( 3, pattern[ (i + 3) % 6 ] );
            wait( 0.05 );
        }
    }
}

void random0( void ) {
    U16     tmp_buffer[ CUBE_SIZE ]    = { 0, 0, 0, 0 };
    U16     tmp;
    int     layer;

    while ( !g_switch_demo ) {
        layer   = rand() & 0x3;
        tmp     = 0x0001 << (rand() & 0xF);
        tmp_buffer[ layer ] ^= tmp;
        
        cube.set_bits( layer, tmp_buffer[ layer ] );
        wait( 0.05 );
    }
    
    for ( int i = 0; i < 200; i++ )
    {
        layer   = rand() & 0x3;
        tmp     = 0x0001 << (rand() & 0xF);
        tmp_buffer[ layer ] &= ~tmp;
        
        cube.set_bits( layer, tmp_buffer[ layer ] );
        wait( 0.01 );
    }
}

void random1( void ) {
    while ( !g_switch_demo ) {
        cube.set_bits( 0, (U16)rand() );
        cube.set_bits( 1, (U16)rand() );
        cube.set_bits( 2, (U16)rand() );
        cube.set_bits( 3, (U16)rand() );
        wait( 0.2 );
    }
}

void fill( void ) {
    U16         tmp_buffer[ CUBE_SIZE ]    = { 0, 0, 0, 0 };

    for ( int c = 0; c < CUBE_SIZE; c++ ) {
        for ( int i = 0; i < SR_BIT_LENGTH; i++ ) {
            tmp_buffer[ c ]     = tmp_buffer[ c ] | 0x1 << i;
            cube.set_bits( tmp_buffer );
            wait( 0.07 );
        }
    }
    while ( !g_switch_demo )
        wait( 0.1 );
}

void random_walker( void ) {
    int     pos[ 3 ]    = { 0, 0, 0 };
    int     dim;
    int     direction;

    while ( !g_switch_demo ) {
        dim         = rand() % 3;
        direction   = rand() & 0x1 ? 1: -1;

        if ( (pos[ dim ] == 0) && (direction == -1) )
            direction   = 1;
        else if ((pos[ dim ] == 3) && (direction == 1)  )
            direction   = -1;

        pos[ dim ]  += direction;

        single_turnon( pos[ 0 ], pos[ 1 ],pos[ 2 ] );
    }
}

void single_turnon( int x, int y, int z ) {
    cube.set_bit( x, y, z, 1 );
    wait( 0.05 );
    cube.set_bit( x, y, z, 0 );
}

void dummy_demo( void ) {
}

void demo_switching( void ) {
    g_switch_demo   = 1;
}

