/** mbeduino demo code (with 4x4x4 LED Cube shield)
 *
 *  @class   LED_Cube444
 *  @author  Tedd OKANO
 *  @version 0.51(08-Dec-2010)
 *   
 *      This is a very simple demo code of mbeduino + 4x4x4 LED Cube shield
 *
 *      mbeduino              = http://mbed.org/users/okini3939/notebook/mbeduino/  (Japanese)
 *      4x4x4 LED Cube shield = http://www.galileo-7.com/?pid=20015630  (Japanese)
 *
 *      Released under the MIT License: http://mbed.org/license/mit
 *
 *      revision 0.5   15-Oct-2010   1st release
 *      revision 0.51  08-Dec-2010   Document reformatted / small modification on main function
 */

#include "mbed.h"
#include "LED_Cube444.h"

LED_Cube444 cube;

int main() {

    cube.set_bits( 0, 0xA5A5 );
    cube.set_bits( 1, 0x5A5A );
    cube.set_bits( 2, 0xA5A5 );
    cube.set_bits( 3, 0x5A5A );
    wait( 0.5 );
    
    cube.set_bits( 0, 0x5A5A );
    cube.set_bits( 1, 0xA5A5 );
    cube.set_bits( 2, 0x5A5A );
    cube.set_bits( 3, 0xA5A5 );
    wait( 0.5 );

    cube.clear();

    int v   = 1;

    while ( 1 ) {

        for ( int x = 0; x < 4; x++ ) {
            for ( int y = 0; y < 4; y++ ) {
                for ( int z = 0; z < 4; z++ ) {
                    cube.set_bit( x, y, z, v );
                    wait( 0.01 );
                }
            }
        }

        v   = !v;
    }
}
