#include    "mbed.h"
#include    "IAP.h"

#define     MEM_SIZE        256

#define     TARGET_SECTOR    7      //  use sector 7 as target sector if it is on LPC1768

void    memdump( char *p, int n );
int     isprint( int c );

IAP     iap;

void write_dummy_data( void );


main()
{
    int     r;
    
    //  Write dummy data into Flash sector7
    write_dummy_data();

    printf( "\r\n==== dummy data written ====\r\n" );


    printf( "\r\nShowing flash contents of sector %d\r\n", TARGET_SECTOR );
    memdump( sector_start_adress[ TARGET_SECTOR ], MEM_SIZE );


    //  Try blank check
    r   = iap.blank_check( TARGET_SECTOR, TARGET_SECTOR );
    printf( "Try blank check ==> blank check result = 0x%08X\r\n", r );
    
    //  Try erase
    iap.prepare( TARGET_SECTOR, TARGET_SECTOR );
    r   = iap.erase( TARGET_SECTOR, TARGET_SECTOR );
    printf( "Try erase       ==> erase result       = 0x%08X\r\n", r );
    
    printf( "\r\nShowing flash contents of sector %d\r\n", TARGET_SECTOR );
    memdump( sector_start_adress[ TARGET_SECTOR ], MEM_SIZE );

}

void write_dummy_data( void )
{
    char    mem[ MEM_SIZE ];    //  memory, it should be aligned to word boundary
    int     r;

    printf( "\r\n\r\n=== IAP: Flash memory writing test ===\r\n" );
    printf( "  device-ID = 0x%08X\r\n", iap.read_ID() );

    printf( "  CPU running %dkHz\r\n", SystemCoreClock / 1000 );
    printf( "  user reserved flash area: start_address=0x%08X, size=%d bytes\r\n", iap.reserved_flash_area_start(), iap.reserved_flash_area_size() );

    for ( int i = 0; i < MEM_SIZE; i++ )
        mem[ i ]    = i & 0xFF;

    //  blank check: The mbed will erase all flash contents after downloading new executable

    r   = iap.blank_check( TARGET_SECTOR, TARGET_SECTOR );
    printf( "blank check result = 0x%08X\r\n", r );

    //  erase sector, if required

    if ( r == SECTOR_NOT_BLANK ) {
        iap.prepare( TARGET_SECTOR, TARGET_SECTOR );
        r   = iap.erase( TARGET_SECTOR, TARGET_SECTOR );
        printf( "erase result       = 0x%08X\r\n", r );
    }

    // copy RAM to Flash

    iap.prepare( TARGET_SECTOR, TARGET_SECTOR );
    r   = iap.write( mem, sector_start_adress[ TARGET_SECTOR ], MEM_SIZE );
    printf( "copied: SRAM(0x%08X)->Flash(0x%08X) for %d bytes. (result=0x%08X)\r\n", mem, sector_start_adress[ TARGET_SECTOR ], MEM_SIZE, r );

    // compare

    r   = iap.compare( mem, sector_start_adress[ TARGET_SECTOR ], MEM_SIZE );
    printf( "compare result     = \"%s\"\r\n", r ? "FAILED" : "OK" );
}


void memdump( char *base, int n )
{
    unsigned int    *p;

    printf( "  memdump from 0x%08X for %d bytes", (unsigned long)base, n );

    p   = (unsigned int *)((unsigned int)base & ~(unsigned int)0x3);

    for ( int i = 0; i < (n >> 2); i++, p++ ) {
        if ( !(i % 4) )
            printf( "\r\n  0x%08X :", (unsigned int)p );

        printf( " 0x%08X", *p );
    }

    printf( "\r\n" );
}
