#include    "mbed.h"
#include    "SDFileSystem.h"
#include    "DirectoryList.h"

SDFileSystem sd( p5, p6, p7, p8, "sd" );

#define     TARGET_DIRECTORY    "/sd/DCIM/100D3100"

int main(void)
{
    printf( "\r\n  == DirectryList test with SDFileSystem ==\r\n" );
    printf( "accessing to \"%s\"\r\n", TARGET_DIRECTORY );
    //
    //  make an instance and get file name list
    //
    
    DirectoryList   dir( TARGET_DIRECTORY );

    //
    //  check if the directory list is obtained successfully
    //
    
    if ( dir.error_check() )
        error( "directory could not be opened\r\n" );

    //
    //  show file names
    //  each file names are given as std::string object
    //  (call "c_str()" if you need to convert to "char *")
    //
    //  this sample shows the file name displayed by printf
    //  with converting string class to normal-C-string 
    //
        
    for ( int i = 0; i < dir.size(); i++ )
        printf( "%s\r\n", dir[ i ].c_str() );
}
