/**
 *  DirectoryList library demo program
 *
 *  @author  Tedd OKANO
 *  @version 0.1
 *  @date    Jan-2015
 *
 *  A simple directory listing interface.
 */

#include "mbed.h"
#include "DirectoryList.h"

LocalFileSystem local( "local" );

int main(void)
{
    //
    //  make an instance and get file name list
    //
    
    DirectoryList   dir( "/local" );

    //
    //  check if the directory list is obtained successfully
    //
    
    if ( dir.error_check() )
        error( "directory could not be opened\r\n" );

    //
    //  show file names
    //  each file names are given as std::string object
    //  (call "c_str()" if you need to convert to "char *")
    //
    //  this sample shows the file name displayed by printf
    //  with converting string class to normal-C-string 
    //
        
    for ( int i = 0; i < dir.size(); i++ )
        printf( "%s\r\n", dir[ i ].c_str() );
}
