
/***********************************************************
    データ取得&送信するプログラム
    各データの終わりの印として'$'を送信
    送信データが時間順にならないため、検証時は並び替えが必要
************************************************************/

//TODO: 30分以上の動作試験

#include "mbed.h"
#include "MPU6050.h"
#include "MS5607I2C.h"

#define ACC 16384
#define BUFFNUM 50  /*受信側のBUFFNUMと同値*/
#define CHARANUM 50
#define RATE 50.0   /*RATE[Hz]でデータ取得*/


MPU6050 mpu(p9,p10);
MS5607I2C  ms5607(p9,p10,false);
Serial  subCP(p28, p27);
Ticker  log_timer;
Timer   t;

float  Time[2][BUFFNUM] = {};
float  Acc[2][BUFFNUM]  = {};
float  Alt[2][BUFFNUM]  = {};
char   Moji[2][BUFFNUM][CHARANUM] = {};
bool   Row = false;
int8_t Col = 0;
int    Send_cnt = 0;
int    Moji_cnt = 0;

void _log();

int main(){
    t.start();
    log_timer.attach(_log,1.0/RATE);
    while(1){
        if(Moji_cnt==0){
            sprintf(&Moji[Row][Send_cnt][0],"%f, %f, %f",Time[!Row][Send_cnt],Acc[!Row][Send_cnt],Alt[!Row][Send_cnt]);
        }
        subCP.putc(Moji[Row][Send_cnt][Moji_cnt]);
        Moji_cnt++;
        if(Moji_cnt==CHARANUM || Moji[Row][Send_cnt][Moji_cnt]=='\0'){
            Moji_cnt = 0;
            subCP.putc('$');
            Send_cnt++;
            if(Send_cnt==BUFFNUM){
                Send_cnt = 0;
            }
        }
    }
}

/*  データ取得関数   */
void _log(){
    mpu.getAccelero(&Acc[Row][Col]);
    Alt[Row][Col]  = ms5607.getAltitude();
    Time[Row][Col] = t.read();
    if(Time[Row][Col]>=1800){
        t.reset();
    }
    Col++;
    if(Col == BUFFNUM){
        Col = 0;
        Row = !Row;
    }
}

