#include "mbed.h"
#include "ADXL375_i2c.h"

Serial pc(USBTX, USBRX, 115200); 
I2C i2c(p9, p10);
ADXL375_i2c ADXL375(i2c, ADXL375_i2c::ALT_ADDRESS_HIGH);

float acc[3];


void setup();


int main(){
    setup();

    // 開始直後にFIFOに入った分をクリア
    for(int i=0; i<ADXL375.getFifoEntries(); i++) {
        ADXL375.getOutput(acc);
    }        

    while(1){
        int entries = ADXL375.getFifoEntries();
        if(entries > 0) {
            pc.printf("\n%2d: ", entries );
            for(int i=0; i<entries; i++) {
                ADXL375.getOutput(acc);
                pc.printf("%.2f,%.2f,%.2f/ ",acc[0], acc[1], acc[2]);
            }
            pc.printf("\n");
        } else {
            pc.printf(".");
        }
        wait(0.1); // FIFOの効果を見るため、わざと遅めにループする
    }
}



void setup(){
    
    ADXL375.setDataRate(ADXL375_25HZ);
    if(ADXL375.whoAmI() == 1){
        pc.printf("ADXL375 : OK\r\n");
    }
    else{
        pc.printf("ADXL375 : NG.....\r\n");
    }
    ADXL375.offset(-0.2f, -0.4f, 0.6f);
    ADXL375.setFifoMode(true);
}