/*
MultiClick library sample program:
  For one button operation.
  This library suports these events,
    * Single click
    * Double click
    * N times click (over 3 times click)
    * Long press

The MIT License (MIT)

Copyright (c) 2016 Uematsu Electric Co.,Ltd. Toru OHTSUKA <t-ohtsuka@jupiter.ocn.ne.jp>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "MultiClick.h"

Serial pc(USBTX,USBRX);

DigitalOut myled(LED1);

MultiClick btn(dp24, PullUp);

void clicked(void){
    printf("\n********** single clicked.\n");
}

void d_clicked(void){
    printf("\n********** double clicked.\n");
}

void n_clicked(int times){
    printf("\n********** %d clicked.\n", times);
}

void longpressed(void){
    printf("\n********** longpressed.\n");
}

int main() {
    pc.baud(115200);
    
    btn.attach_clicked(clicked);
    btn.attach_doubleclicked(d_clicked);
    btn.attach_n_clicked(n_clicked);
    btn.attach_longpressed(longpressed);
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
