/*
 *  Sample program for LPS331_SPI library.
 *
 *  Copyright(c) -2016 Toru OHTSUKA, 
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.0    07-Jul-2016     1st release.
 */

#include "mbed.h"
#include "LPS331_SPI.h"

DigitalOut myled(LED1);

LPS331_SPI press(dp2, dp1, dp6, dp26);

int main() {
    char whoami;
    
    whoami = press.whoami();
    printf("WHO_AM_I REG. = 0x%X, ", whoami);
    if(press.isLPS331()) {
        printf("This sensor is LPS331.\n\n");
    } else if(press.isLPS25H()) {
        printf("This sensor is LPS25H.\n\n");
    } else {
        printf("Unknown sensor.\n\n");
    }
    
    press.quickStart();
    while(1) {
        float pressure;
        pressure = press.getPressure();
        printf("pressrue = %f\n", pressure);

        myled = !myled;
        wait(0.2);
    }
}

