/*
 *  I2C/SPI digital pressure sensor "LPS331AP" "LPS25H" library for SPI mode.
 *
 *  http://www.st.com/web/en/resource/technical/document/datasheet/DM00036196.pdf
 *
 *  Copyright(c) -2016 Toru OHTSUKA, 
 *  Copyright(c) -2013 unos@NYAMFG, 
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.2    07-Jul-2016     SPI version.
 *  revision 1.1    22-Oct-2013     Add multibyte read, Change temperature and pressure reading method.
 *  revision 1.0    20-Oct-2013     1st release, Does not support interrupts.
 */

#ifndef LPS331_SPI_H
#define LPS331_SPI_H

#include "mbed.h"

// SA0 status configuration values.
#define LPS331_SPI_SA0_HIGH         true
#define LPS331_SPI_SA0_LOW          false

// Pressure configuration values.
#define LPS331_SPI_PRESSURE_AVG_1   0x00
#define LPS331_SPI_PRESSURE_AVG_2   0x01
#define LPS331_SPI_PRESSURE_AVG_4   0x02
#define LPS331_SPI_PRESSURE_AVG_8   0x03
#define LPS331_SPI_PRESSURE_AVG_16  0x04
#define LPS331_SPI_PRESSURE_AVG_32  0x05
#define LPS331_SPI_PRESSURE_AVG_64  0x06
#define LPS331_SPI_PRESSURE_AVG_128 0x07
#define LPS331_SPI_PRESSURE_AVG_256 0x08
#define LPS331_SPI_PRESSURE_AVG_384 0x09
#define LPS331_SPI_PRESSURE_AVG_512 0x0a

// Temperature configuration values.
#define LPS331_SPI_TEMP_AVG_1       0x00
#define LPS331_SPI_TEMP_AVG_2       0x01
#define LPS331_SPI_TEMP_AVG_4       0x02
#define LPS331_SPI_TEMP_AVG_8       0x03
#define LPS331_SPI_TEMP_AVG_16      0x04
#define LPS331_SPI_TEMP_AVG_32      0x05
#define LPS331_SPI_TEMP_AVG_64      0x06
#define LPS331_SPI_TEMP_AVG_128     0x07

// Data Rate                                   Pressure / Temperature 
#define LPS331_SPI_DATARATE_ONESHOT 0x00    // OneShot    OneShot
#define LPS331_SPI_DATARATE_1HZ     0x01    // 1Hz        1Hz
#define LPS331_SPI_DATARATE_7HZ     0x02    // 7Hz        1Hz
#define LPS331_SPI_DATARATE_12_5HZ  0x03    // 12.5Hz     1Hz
#define LPS331_SPI_DATARATE_25HZ    0x04    // 25Hz       1Hz
#define LPS331_SPI_DATARATE_7HZ_T   0x05    // 7Hz        7Hz
#define LPS331_SPI_DATARATE_12_5HZ_T 0x06   // 12.5Hz     12.5Hz
#define LPS331_SPI_DATARATE_25HZ_T  0x07    // 25Hz       25Hz (*)
// (*) Not allowed with PRESSURE_AVG_512 & TEMP_AVG_128.
//     More information , see datasheet.

// I2C Address.
#define LPS331_SPI_ADDRESS_SA0_HIGH 0xba   
#define LPS331_SPI_ADDRESS_SA0_LOW  0xb8

class LPS331_SPI
{
public:
    LPS331_SPI(PinName mosi, PinName miso, PinName sclk, PinName cs);
    ~LPS331_SPI();

    char whoami();
    bool isLPS331();
    bool isLPS25H();
    
    void setResolution(char pressure_avg, char temp_avg);
    void setActive(bool is_active);
    void setDataRate(char datarate);

    void quickStart();

    float getPressure();
    float getTemperature();

    void _write(char subaddress, char data);
    char _read(char subaddress);
    void _read_multibyte(char startsubaddress, char* data, char count);
        
private:
    SPI _spi;
    DigitalOut _cs;
    char _address;
    char _ctrlreg1;
};


#endif /* LPC331_SPI_H */

