#include "mbed.h"
#include <math.h>
#include "LPS331_I2C.h"

//気圧計算用
#define P0 1013.25f //海面気圧(hPa)
#define TEMP 20     //気温(度)

DigitalOut myled(LED1);
DigitalOut JPlow(p5); // p6ピンでLowを検出させるために使用
DigitalIn JP(p6);     // p5とp6のピンを接続するとログ出力停止
LocalFileSystem local("local"); 

Serial telem(p13,p14);

Timer t;

//地面との相対高度算出用
#define GROUND_AVE_NUM 10
float ground_alti=0;

LPS331_I2C lps331(p9, p10, LPS331_I2C_SA0_HIGH); // 気圧センサ

int main() {
    int i;
    float temp, pres;
    JPlow = 0;
    JP.mode(PullUp);

    // 気圧センサーの初期化------------------------------------------
    lps331.setResolution(LPS331_I2C_PRESSURE_AVG_512, LPS331_I2C_TEMP_AVG_128);
    lps331.setDataRate(LPS331_I2C_DATARATE_7HZ); // 7Hz(1秒間に7回更新)
    lps331.setActive(true); // 動作開始
              
    // ファイルにデータの区切り用メッセージを出力 -----------------------
    FILE *fp = fopen("/local/data.txt", "a");   // 「追記」でファイルを開く
    fprintf(fp,"BBsat start. **********\r\n");  // fprintf()は、ファイルに文字を出力
    fclose(fp);

    // テレメトリにデータの区切り用メッセージを出力 ---------------------
    telem.printf("BBsat start. **********\r\n");  // テレメトリ用出力

    t.start(); // 起動からの時間を測るために時計をスタート

    // 地面の高度を求める --------------------------------------------
    for(i=0;i<GROUND_AVE_NUM;i++) {
        pres = lps331.getPressure();    // 気圧
        ground_alti += lps331.getAltitude(P0, TEMP, pres);
        wait(1/7);
    }
    ground_alti = ground_alti / GROUND_AVE_NUM;
    
    // 高度を繰り返し計測する -----------------------------------------
    while(1) {
        int ms=0;       // リセットからの経過時間(単位:ミリ秒(MilliSecond)
        float altitude;               // 高度
        pres=lps331.getPressure();    // 気圧
        temp=lps331.getTemperature(); // 気温

        // 気圧から高度を求める ---------------------------------------
        altitude = lps331.getAltitude(P0, TEMP, pres);
        
        // 気圧の記録を停止するかをチェック -----------------------------
        if(JP==0) {     // JPが0(GND)だったら、
            break;      //whileのループを終了
        }

        ms = t.read_ms(); //現在時刻を取得

        // ファイルに記録 ---------------------------------------------
        FILE *fp = fopen("/local/data.txt", "a");
        fprintf(fp,  "%10d,%6.2f,%4.1f %5.1f \r\n", ms, pres, temp, altitude);   // 時刻,気圧,気温,高度を出力
        printf(      "%10d,%6.2f,%4.1f,Ground:%5.1f altitude:%5.1f Diff%5.1f \r\n",
            ms, pres, temp, ground_alti, altitude, altitude-ground_alti);
        fclose(fp);

        // 高度のみテレメトリ出力 ---------------------------------------
        telem.printf("%5.1f\n", altitude-ground_alti);   // 高度を出力
 
        // 動作確認用 LED点滅 -----------------------------------------
        wait(0.05);     // 
        myled = 1;
        wait(0.05);
        myled = 0;
    }
}
