#include "ADXL375_i2c.h"

ADXL375_i2c :: ADXL375_i2c(I2C &userI2C, ALT_ADDRESS LOW_HIGH){
    if(LOW_HIGH == ALT_ADDRESS_LOW){
        ADXL375_I2C_READ = ADXL375_I2C_LOW_READ;
        ADXL375_I2C_WRITE = ADXL375_I2C_LOW_WRITE;
        ADXL375_I2C_ADDRESS = ADXL375_I2C_LOW_ADDRESS;
    }
    else if(LOW_HIGH == ALT_ADDRESS_HIGH){
        ADXL375_I2C_READ = ADXL375_I2C_HIGH_READ;
        ADXL375_I2C_WRITE = ADXL375_I2C_HIGH_WRITE;
        ADXL375_I2C_ADDRESS = ADXL375_I2C_HIGH_ADDRESS;
    }
    
    i2c = &userI2C;
    i2c -> frequency(400000);
    
    char tx[2];
    tx[0] = ADXL375_BW_RATE_REG;
    tx[1] = ADXL375_3200HZ;
    i2c -> write(ADXL375_I2C_WRITE, tx, 2);
    
    char rx[2];
    rx[0] = ADXL375_DATA_FORMAT_REG;
    rx[1] = 0x0B;
    i2c -> write(ADXL375_I2C_WRITE, rx, 2);
    
    char x[2];
    x[0] = ADXL375_OFSX_REG ;
    x[1] = 0xFE;
    i2c -> write(ADXL375_I2C_WRITE, x, 2);
    char y[2];
    y[0] = ADXL375_OFSY_REG ;
    y[1] = 0xFE;
    i2c -> write(ADXL375_I2C_WRITE, y, 2);
    char z[2];
    z[0] = ADXL375_OFSZ_REG ;
    z[1] = 0x00;
    i2c -> write(ADXL375_I2C_WRITE, z, 2);
    
    singleByteWrite(ADXL375_POWER_CTL_REG, 0x08);
    
    offset_x = offset_y = offset_z = 0.0f;
}

char ADXL375_i2c :: singleByteRead(char address){
    char tx = address;
    char output;
    i2c -> write(ADXL375_I2C_WRITE, &tx, 1);
    i2c -> read(ADXL375_I2C_READ, &output, 1);
    return output;
}

void ADXL375_i2c :: singleByteWrite(char address, char data){
    char tx[2];
    tx[0] = address;
    tx[1] = data;
    i2c -> write(ADXL375_I2C_WRITE, tx, 2);
}

void ADXL375_i2c :: multiByteRead(char address, char* output, int size){
    i2c -> write(ADXL375_I2C_WRITE, &address, 1);
    i2c -> read(ADXL375_I2C_READ, output, size);
}

void ADXL375_i2c :: getOutput(float* output){
    char buffer[6];
    short int data[3];
    multiByteRead(ADXL375_DATAX0_REG, buffer, 6);
    data[0] = (int)buffer[1] << 8 | (int)buffer[0];
    data[1] = (int)buffer[3] << 8 | (int)buffer[2];
    data[2] = (int)buffer[5] << 8 | (int)buffer[4];
    
    output[0] = (float)data[0] / 20.0f - offset_x;
    output[1] = (float)data[1] / 20.0f - offset_y;
    output[2] = (float)data[2] / 20.0f - offset_z;
}

int ADXL375_i2c :: whoAmI(){
    char who_am_i = singleByteRead(ADXL375_DEVID_REG);
    if(who_am_i == 0xE5){
        return 1;
    }
    else{
        return -1;
    }
}

void ADXL375_i2c :: offset(float x, float y, float z){
    offset_x = x;
    offset_y = y;
    offset_z = z;
}

void ADXL375_i2c :: setDataRate(char rate){
    char buff = singleByteRead(ADXL375_BW_RATE_REG);
    buff &= 0x10;
    buff |= rate;
    singleByteWrite(ADXL375_BW_RATE_REG, buff);
}

void ADXL375_i2c :: setFifoMode(bool is_fifo_on){
    char buff = singleByteRead(ADXL375_FIFO_CTL);
    buff &= 0x3F;
    if(is_fifo_on == true) {
        buff |= 0x40;
    }    
    singleByteWrite(ADXL375_FIFO_CTL, buff);
    
    printf("FIFO_CTL reg. = %2X\n", singleByteRead(ADXL375_FIFO_CTL));
}

int ADXL375_i2c :: getFifoEntries(void){
    char buff = singleByteRead(ADXL375_FIFO_STATUS);
//    printf("ADXL375_FIFO_STATUS reg. = %02X\n", buff);
    buff &= 0x3F;
//    printf("ADXL375_FIFO_STATUS reg(Entries) = %d\n", buff);
    
    return (int)buff;
}