#include "ADXL345_I2C.h"

ADXL345_I2C accelerometer(p28, p27);
Serial pc(USBTX, USBRX);
Serial device(p9, p10); // tx, rx

//for LEDs-----------------------------------------
    DigitalOut debug1(LED1); //for debug
    DigitalOut debug2(LED2); //for debug
    DigitalOut debug3(LED3); //for debug
    DigitalOut debug4(LED4); //for debug
//---------------------------------------------


int main() {
    pc.baud(9600);
    int readings[3] = {0, 0, 0};
    char tmp;
    
    while(1){     
        pc.printf("Starting ADXL345 test...\n");
        wait(.001);
        pc.printf("Device ID is: 0x%02x\n", accelerometer.getDeviceID());
        wait(.001);
    
        // These are here to test whether any of the initialization fails. It will print the failure
        if (accelerometer.setPowerControl(0x00)){
            pc.printf("didn't intitialize power control\n"); 
            return 0;  
        }
        //Full resolution, +/-16g, 4mg/LSB.
        wait(.001);
     
        if(accelerometer.setDataFormatControl(0x0B)){
            pc.printf("didn't set data format\n");
            return 0;  
        }
        wait(.001);
     
        //3.2kHz data rate.
        if(accelerometer.setDataRate(ADXL345_3200HZ)){
            pc.printf("didn't set data rate\n");
            return 0;
        }
        wait(.001);
     
        //Measurement mode.
     
        if(accelerometer.setPowerControl(MeasurementMode)) {
            pc.printf("didn't set the power control to measurement\n"); 
            return 0;   
        } 
          
        while (1) {
        wait(0.1); 
        accelerometer.getOutput(readings);
        int dice_number = 0;
        
        if ((int16_t)readings[0]>200){
        dice_number = 1;
        }
        else if ((int16_t)readings[0]<-200){
        dice_number = 6;        
        }
        else if ((int16_t)readings[1]>200){
        dice_number = 2;
        }
        else if ((int16_t)readings[1]<-200){
        dice_number = 5;
        }
        else if ((int16_t)readings[2]>200){
        dice_number  = 3;
        }
        else if ((int16_t)readings[2]<-200){
        dice_number = 4;
        }
        
        pc.printf("%i\r\n", dice_number);
        }
        
        tmp = pc.getc();
        
        if(tmp == '0') {
            pc.putc(tmp);
            debug3 = 1;
            debug4 = 0;
        } else {
            pc.printf("Fuck You!!\r\n");
            pc.printf("tmp : %d\r\n", tmp);
            debug4 = 1;
            debug3 = 0;
        }
    }
        
}