#include "mbed.h";

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut debug1(LED1);

// display character from pc using interrupt
void rxCallBack(void) {
    debug1 = !debug1;
    pc.putc(pc.getc());
}
 
int main() {
    
    // define interrupt
    pc.attach(rxCallBack, Serial::RxIrq);
    
    char TSUBAME[] = {'T','S','U','B','A','M','E',' '}; // 8
    char data[] = {'8','8',' ','2','0',' ','C','2',' ','9','A',' ','0','1',' ','0','1',' ','2','E',' ','2','E',' ','1','8',' ','4','3',' ','8','7',' ','F','8',' ','0','9',' ','0','9',' ','0','0',' ','0','1',' '};    // 32
    char MESSAGE[] = {'H','I',' ','H','I',' ','D','E',' ','J','Q','1','Y','T','C',' '}; // 15
    
    while(1)
    {
        int i;
        for(i=0; i<8; i++)
        {
            pc.putc(TSUBAME[i]);
            pc.printf("\r\n");
            wait(0.1);
        }
        for(i=0; i<48; i++)
        {
            pc.putc(data[i]);
            pc.printf("\r\n");
            wait(0.1);
        }
        for(i=0; i<16; i++)
        {
            pc.putc(MESSAGE[i]);
            pc.printf("\r\n");
            wait(0.1);
        }
    }
}

