#include "mbed.h"
#include "RS405cb.h"

//for LEDs-----------------------------------------
    DigitalOut debug1(LED1); //for debug
    DigitalOut debug2(LED2); //for debug
    DigitalOut debug3(LED3); //for debug
    DigitalOut debug4(LED4); //for debug
//---------------------------------------------

//for Communications---------------------------------------------
    Serial xbee(p9, p10);   //tx, rx (Xbee)
    Serial pc(USBTX, USBRX);    //tx, rx (PC)
//---------------------------------------------

//for servo-----------------------------------------
    RS405cb servo(p13,p14,p15);    //TX,RX,PERMIT  (PERMIT means RE/DE Pin of ltc485)
//---------------------------------------------

    void move_sample();

int main() {
    // servo.TORQUE_ON(id); make servo torque ON. servo id is below
    // servo id 1 : z-axis
    //          2 : x-axis  shoulder joint
    //          3 : x-axis  elbow joint
    //          4 : x-axis  wrist joint
    servo.TORQUE_ON(1);
    servo.TORQUE_ON(2);
    servo.TORQUE_ON(3);
    servo.TORQUE_ON(4);
    
    // servo.Rotate_Servo_Float(id,theta); rotate servo from its position to "theta"
    // ex) servo.Rotate_Servo_Float(3,90.0); rotate elbow joint servo (id=3) from its position to 90.0 degree
    // range of servo's rot-angle is from -150deg to 150deg
    servo.Rotate_Servo_Float(1,0.0);
    servo.Rotate_Servo_Float(2,0.0);
    servo.Rotate_Servo_Float(3,0.0);
    servo.Rotate_Servo_Float(4,0.0);

    while(1) {
        move_sample();
    } 
}

// servo move sample below
// move servo(id:1) from 0 deg to 150 deg and come back endlessly
void move_sample()
{
    while(1)
    {
        for(int i=; i<1000; i++)
        {
            servo.Rotate_Servo_Float(1,150.0/i);
            wait(0.05);
        }
        for(int i=0; i<1000; i++)
        {
           servo.Rotate_Servo_Float(1,150-150.0/i);
           wait(0.05)
        }
    }
}