/*
 * TinyJS for mbed.
 *
 * Authored by Takehisa Oneta (ohneta@gmail.com)
 * 10th Jan. 2013
 */

/*
 * JavaScript samples
 *    for (x = 0; x < 256; x++) {for (var i = 0; i <= 3; i++) {mbed.DigitalOut(led1, (1 << i) & 0x01);mbed.DigitalOut(led2, (1 << i) & 0x02);mbed.DigitalOut(led3, (1 << i) & 0x04);mbed.DigitalOut(led4, (1 << i) & 0x08);for (j = 0; j < 300; j++) dummy=0;}for (var i = 3; i >= 0; i--) {mbed.DigitalOut(led1, (1 << i) & 0x01);mbed.DigitalOut(led2, (1 << i) & 0x02);mbed.DigitalOut(led3, (1 << i) & 0x04);mbed.DigitalOut(led4, (1 << i) & 0x08);for (j = 0; j < 10; j++) dummy=0;}};
 */
 
#include "mbed.h"
#include "TinyJS.h"
#include "Mbed_Functions.h"

Serial pc(USBTX, USBRX);

//unsigned char usbArea[1024] __attribute__((section("AHBSRAM0")));
//unsigned char ethArea[1024] __attribute__((section("AHBSRAM1")));


extern int tinyjs_main(int argc, char **argv);

//---------------------------------------------

int readOneLine(char *buffer, const int bufferSize)
{
    int len = 0;

    buffer[0] = '\0';
    while (true) {
        char c = pc.getc();
        pc.putc(c);

        if ('\r' == c) {
            return len;
        } else if( '\n' == c ) {
        } else {
            buffer[len] = c;
            buffer[len + 1] = '\0';
            len++;
            if (len > bufferSize) {
                return len;
            }
        }
    }

    return len;
}

//---------------------------------------------
//---------------------------------------------

int main() {
    pc.baud(57600);

    while(1) {
        printf("\n");
        printf("--------------------------\n");
        printf("TinyJS on mbed\n");

        tinyjs_main(NULL, NULL);

        printf("--------------------------\n");
        printf("bye bye\n");
    }
}
