/*
 * TinyJS for mbed.
 * Mbed_Functions.cpp
 *
 * Authored by Takehisa Oneta (ohneta@gmail.com)
 * 17th Jan. 2014 -
 */

#include "mbed.h"
#include "TinyJS.h"
#include "Mbed_Functions.h"

//---------------------------------------------

void mbedDigitalIn(CScriptVar *c, void *)
{
    string pinNameString = c->getParameter("pinName")->getString();
    PinName pinName = _mbedPinNameExchange(pinNameString);
    string modeString = c->getParameter("mode")->getString();

    int mode = PullDown;
    if (modeString == "PullUp") {
        mode = PullUp;
    } else if (modeString == "PullNone"){
        mode = PullNone;
    } else if (modeString == "PullDown") {
        mode = PullDown;
    }

    DigitalIn din = DigitalIn((PinName)pinName);
    din.mode((PinMode)mode);
    int val = din.read();
    c->getReturnVar()->setInt(val);
}

void mbedDigitalOut(CScriptVar *c, void *)
{
    string pinNameString = c->getParameter("pinName")->getString();
    PinName pinName = _mbedPinNameExchange(pinNameString);

    int val = c->getParameter("val")->getInt();

    DigitalOut dout = DigitalOut((PinName)pinName);
    dout.write(val);
}

//---------------------------------------------

void mbedAnalogIn(CScriptVar *c, void *)
{
    string pinNameString = c->getParameter("pinName")->getString();
    PinName pinName = _mbedPinNameExchange(pinNameString);

    AnalogIn ain = AnalogIn((PinName)pinName);
    float val = ain.read();

    c->getReturnVar()->setDouble(val);
}

void mbedAnalogOut(CScriptVar *c, void *)
{
    string pinNameString = c->getParameter("pinName")->getString();
    PinName pinName = _mbedPinNameExchange(pinNameString);
    float val = c->getParameter("val")->getDouble();

    AnalogOut aout = AnalogOut((PinName)pinName);
    aout.write(val);
}

//---------------------------------------------
#define INTERRUPT_NUM   4
CTinyJS *_mbed_interruptIn_tinyJS;
int _mbed_interruptIn_Count = 0;
string _mbed_interruptIn_callbackStrings[INTERRUPT_NUM];
InterruptIn* _mbed_interrupt_array[INTERRUPT_NUM] = {NULL, NULL, NULL, NULL};

void _interruptVector0(){
    _mbed_interruptIn_tinyJS->execute(_mbed_interruptIn_callbackStrings[0]);
}
void _interruptVector1(){
    _mbed_interruptIn_tinyJS->execute(_mbed_interruptIn_callbackStrings[1]);
}
void _interruptVector2(){
    _mbed_interruptIn_tinyJS->execute(_mbed_interruptIn_callbackStrings[2]);
}
void _interruptVector3(){
    _mbed_interruptIn_tinyJS->execute(_mbed_interruptIn_callbackStrings[3]);
}

void mbedInterruptIn(CScriptVar *c, void *data)
{
    string pinNameString = c->getParameter("pinName")->getString();
    PinName pinName = _mbedPinNameExchange(pinNameString);

    string edgeString = c->getParameter("edge")->getString();
    string modeString = c->getParameter("mode")->getString();
    PinMode mode = PullDown;
    if (modeString == "PullUp") {
        mode = PullUp;
    } else if (modeString == "PullNone"){
        mode = PullNone;
    } else if (modeString == "PullDown") {
        mode = PullDown;
    }

    _mbed_interruptIn_tinyJS = (CTinyJS *)data;
    _mbed_interruptIn_callbackStrings[_mbed_interruptIn_Count] = c->getParameter("callback")->getString();

    if (_mbed_interrupt_array[_mbed_interruptIn_Count] != NULL) {
        delete _mbed_interrupt_array[_mbed_interruptIn_Count];
    }

    _mbed_interrupt_array[_mbed_interruptIn_Count] = new InterruptIn(pinName);
    _mbed_interrupt_array[_mbed_interruptIn_Count]->mode(mode);

    if (_mbed_interruptIn_Count == 0) {
        if (edgeString == "fall")      _mbed_interrupt_array[_mbed_interruptIn_Count]->fall(_interruptVector0);
        else if (edgeString == "rise") _mbed_interrupt_array[_mbed_interruptIn_Count]->rise(_interruptVector0);
    } else if (_mbed_interruptIn_Count == 1) {
        if (edgeString == "fall")      _mbed_interrupt_array[_mbed_interruptIn_Count]->fall(_interruptVector1);
        else if (edgeString == "rise") _mbed_interrupt_array[_mbed_interruptIn_Count]->rise(_interruptVector1);
    } else if (_mbed_interruptIn_Count == 2) {
        if (edgeString == "fall")      _mbed_interrupt_array[_mbed_interruptIn_Count]->fall(_interruptVector2);
        else if (edgeString == "rise") _mbed_interrupt_array[_mbed_interruptIn_Count]->rise(_interruptVector2);
    } else if (_mbed_interruptIn_Count == 3) {
        if (edgeString == "fall")      _mbed_interrupt_array[_mbed_interruptIn_Count]->fall(_interruptVector3);
        else if (edgeString == "rise") _mbed_interrupt_array[_mbed_interruptIn_Count]->rise(_interruptVector3);
    }

    c->getReturnVar()->setInt(_mbed_interruptIn_Count);

    _mbed_interruptIn_Count++;
    if (_mbed_interruptIn_Count >= INTERRUPT_NUM) {
        _mbed_interruptIn_Count = 0;
    }
}

/*
void mbedRemoveInterrupt(CScriptVar *c, void *)
{
    int intrno = c->getParameter("interrupt_no")->getInt();
}
*/

//---------------------------------------------

void mbedWait(CScriptVar *c, void *)
{
    float val = c->getParameter("s")->getDouble();
    wait(val);
}

//---------------------------------------------
/**
 *
 */
void mbedMemfree(CScriptVar *c, void *)
{
    int i = 0;
    while(1) {
        void *p = malloc(i);
        if (p == NULL)  break;
        free(p);
        i++;
    }
    c->getReturnVar()->setInt(i);
}

//---------------------------------------------
PinName _mbedPinNameExchange(string pinNameString)
{
    if (pinNameString == "p5") return p5;
    if (pinNameString == "p6") return p6;
    if (pinNameString == "p7") return p7;
    if (pinNameString == "p8") return p8;
    if (pinNameString == "p9") return p9;
    if (pinNameString == "p10") return p10;
    if (pinNameString == "p11") return p11;
    if (pinNameString == "p12") return p12;
    if (pinNameString == "p13") return p13;
    if (pinNameString == "p14") return p14;
    if (pinNameString == "p15") return p15;
    if (pinNameString == "p16") return p16;
    if (pinNameString == "p17") return p17;
    if (pinNameString == "p18") return p18;
    if (pinNameString == "p19") return p19;
    if (pinNameString == "p20") return p20;

    if (pinNameString == "p21") return p21;
    if (pinNameString == "p22") return p22;
    if (pinNameString == "p23") return p23;
    if (pinNameString == "p24") return p24;
    if (pinNameString == "p25") return p25;
    if (pinNameString == "p26") return p26;
    if (pinNameString == "p27") return p27;
    if (pinNameString == "p28") return p28;
    if (pinNameString == "p29") return p29;
    if (pinNameString == "p30") return p30;


    if (pinNameString == "LED1") return LED1;
    if (pinNameString == "LED2") return LED2;
    if (pinNameString == "LED3") return LED3;
    if (pinNameString == "LED4") return LED4;

    if (pinNameString == "USBTX") return USBTX;
    if (pinNameString == "USBRX") return USBRX;

    return NC;
}

//---------------------------------------------
Timer _mbedTimer;

void mbedTimerStart(CScriptVar *c, void *) {
    _mbedTimer.start();
}

void mbedTimerStop(CScriptVar *c, void *) {
    _mbedTimer.stop();
}

void mbedTimerReset(CScriptVar *c, void *) {
    _mbedTimer.reset();
}

void mbedTimerRead(CScriptVar *c, void *) {
    float tm = _mbedTimer.read();
    c->getReturnVar()->setDouble(tm);
}


//---------------------------------------------
Timeout _mbedTimeout;
CTinyJS *_mbedTimeout_tinyJS;
string _mbedTimeout_callbackStrings;

void _mbedTimeoutVector() {
    _mbedTimeout_tinyJS->execute(_mbedTimeout_callbackStrings);
}

void mbedTimeout(CScriptVar *c, void *data) {
    
    _mbedTimeout_tinyJS = (CTinyJS *)data;
    _mbedTimeout_callbackStrings = c->getParameter("callback")->getString();
    float t = c->getParameter("t")->getDouble();

    _mbedTimeout.attach(&_mbedTimeoutVector, t);
}


//---------------------------------------------
// ----------------------------------------------- Register Functions
void registerMbedFunctions(CTinyJS *tinyJS) {
    tinyJS->addNative("function mbed.DigitalIn(pinName, mode)", mbedDigitalIn, 0);
    tinyJS->addNative("function mbed.DigitalOut(pinName, val)", mbedDigitalOut, 0);

    tinyJS->addNative("function mbed.AnalogIn(pinName)", mbedAnalogIn, 0);
    tinyJS->addNative("function mbed.AnalogOut(pinName, val)", mbedAnalogOut, 0);

    tinyJS->addNative("function mbed.InterruptIn(pinName, edge, mode, callback)", mbedInterruptIn, tinyJS);
    tinyJS->addNative("function mbed.wait(s)", mbedWait, 0);
    tinyJS->addNative("function mbed.TimerStart", mbedTimerStart, 0);
    tinyJS->addNative("function mbed.TimerStop", mbedTimerStop, 0);
    tinyJS->addNative("function mbed.TimerReset", mbedTimerReset, 0);
    tinyJS->addNative("function mbed.TimerRead", mbedTimerRead, 0);
    tinyJS->addNative("function mbed.Timeout(callback, t)", mbedTimeout, tinyJS);

    tinyJS->addNative("function mbed.memfree()", mbedMemfree, 0);
}


