/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ESP8266Interface.h"

#define     RESPOSE_BUFFER_SIZE     2048


Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

uint32_t    _tickCount = 0L;
void flash()
{
    led1 = !led1;
    _tickCount++;
}

ESP8266Interface wifi(p9, p10);

/**
 *
 */   
bool parseURL(const char *url, char *scheme, char *host, uint16_t *port, char *path)
{
    *port = 0;

    char *schemePtr = (char *)url;
    char *hostPtr = (char *)strstr(url, "://");
    if (hostPtr == NULL) {
        pc.printf("Could not find host");
        return false;
    }

    memcpy(scheme, schemePtr, hostPtr - schemePtr);
    scheme[hostPtr - schemePtr] = '\0';

    if (strcmp(scheme, "http") == 0) {
        *port = 80;
    } else if(strcmp(scheme, "https") == 0) {
        *port = 433;
    }
            
    hostPtr += 3;
    size_t hostLen = 0;

    char *portPtr = strchr(hostPtr, ':');
    if (portPtr != NULL) {
        hostLen = portPtr - hostPtr;
        portPtr++;
        if (sscanf(portPtr, "%hu", port) != 1) {
            pc.printf("Could not find port");
            return false;
        }
    }

    char* pathPtr = strchr(hostPtr, '/');
    if( hostLen == 0 ) {
        hostLen = pathPtr - hostPtr;
    }

    memcpy(host, hostPtr, hostLen);
    host[hostLen] = '\0';

    size_t pathLen;
    char *fragmentPtr = strchr(hostPtr, '#');
    if(fragmentPtr != NULL) {
        pathLen = fragmentPtr - pathPtr;
    } else {
        pathLen = strlen(pathPtr);
    }

    memcpy(path, pathPtr, pathLen);
    path[pathLen] = '\0';

    return true;
}

#if 0
bool getHttpDebug(SocketInterface *socket, const char *urlStr, char *rsponse)
{
    char scheme[8];
    char host[32];
    uint16_t port;
    char path[256];

    bool res = parseURL(urlStr, scheme, host, &port, path);
pc.printf("%lu:parseURL=%d:  %s -->  %s, %s, %d, %s  \n", _tickCount, res, urlStr, scheme, host, port, path);


    char host_ip[16];
    {
        wifi.getHostByName(host, host_ip);
pc.printf("%lu:host IP address : %s\n", _tickCount, host_ip);
    }

uint32_t ret;

//_tickCount = 0;
    socket->setAddressPort(host_ip, port);
    ret = socket->open();
led2 = 1;
pc.printf("%d:opend : %d: %s:%d\n", _tickCount, ret, host_ip, port);

    char str[512] = {0};
    sprintf(str, "GET %s HTTP/1.1\r\nHost: %s\r\n\r\n", path, host);
pc.printf("%lu: REQUEST:\n%s\n------\n", _tickCount, str);

    // Send Data
pc.printf("%lu:Sending GET data...\n", _tickCount);
    socket->send(str, strlen(str));

pc.printf("%lu:Waiting on reply ... \n", _tickCount);
    int revLen = socket->recv(rsponse, 512, 10000);
    if (revLen == 0) {
        socket->close();
    }
    rsponse[revLen] = 0;
pc.printf("%lu:Received String : (%d) : \n%s\n", _tickCount, revLen, rsponse);
 

led2 = 0;
pc.printf("%lu:socket closed\n", _tickCount);

    return true;
}
#endif

bool getHttp(SocketInterface *socket, const char *urlStr, char *rsponse)
{
   char scheme[8];
    char host[32];
    uint16_t port;
    char path[256];
    bool res = parseURL(urlStr, scheme, host, &port, path);

    char host_ip[16];
    wifi.getHostByName(host, host_ip);
  
    socket->setAddressPort(host_ip, port);
    uint32_t ret = socket->open();

    char str[512] = {0};
    sprintf(str, "GET %s HTTP/1.1\r\nHost: %s\r\n\r\n", path, host);

    socket->send(str, strlen(str));
    int revLen = socket->recv(rsponse, 512, 10000);
    rsponse[revLen] = 0;

    socket->close();
 

    // retBufを httpプロトコルで分解しようか？
    {
        // 最低限でもresult codeくらい調べたい
    }

    return true;
}


int main()
{
    pc.baud(115200);
    
    
    Ticker t;
    t.attach(flash, 0.1f);
    pc.printf("NetworkSocketAPI TEST by ohneta.\r\n");

    int32_t ret = wifi.init();
    pc.printf("wifi.init() : %d\n", ret);

    ret = wifi.connect("elecom2g-15BEAC", "2903851513877");     // SSID-name, SSID-passPhase
    pc.printf("wifi.connect() : %d\n", ret);


    char* myip;
    myip = wifi.getIPAddress();
    pc.printf("IP Address is: %s\n", (myip) ? myip : "No IP");


    // I want to IP address of default gateway(wifi wifi router). because that is preferred DNS server.
    //wifi.setPreferredDns("192.168.2.1");        // Preferred DNS IP-address
    {
        // "192.168.2.132" --> "192.168.2.1"  (maybe)
        uint32_t ip1, ip2, ip3, ip4;
        sscanf(myip, "%3lu.%3lu.%3lu.%3lu",  &ip1, &ip2, &ip3, &ip4);

        char defaultgateway[20] = {0};
        sprintf(defaultgateway, "%lu.%lu.%lu.1", ip1, ip2, ip3);
pc.printf("%lu: Default gateway: %s\n", _tickCount, defaultgateway);
        wifi.setPreferredDns(defaultgateway);        // defaultgateway is Preferred DNS IP-address
        //wifi.setPreferredDns("192.168.2.1");        // defaultgateway is Preferred DNS IP-address
    }



    SocketInterface *socket = wifi.allocateSocket(SOCK_TCP);

    char responseBuffer[RESPOSE_BUFFER_SIZE] = {0};
    getHttp(socket, "http://youthost.com", responseBuffer);

    wifi.disconnect();
    pc.printf(":::Finished\n");

    while(1) {
        int dummy = 1;
    }
}
