//---------------------------------------------------------
/**
 * FunctionGenCommands.h
 */
//---------------------------------------------------------

#define FGC_BUFFERTRANSFER_MAX  16

typedef enum {
    // commands
    FGCommand_Non = 0x00,
    FGCommand_Device,
    FGCommand_Output,
    FGCommand_Frequency,
    FGCommand_WaveformInfo,
    FGCommand_WaveformBlock,
    FGCommand_WaveformToBuffer,

    // status
    FGStatus_Device    = 0x80 | FGCommand_Device,
    FGStatus_Output    = 0x80 | FGCommand_Output,
    FGStatus_Frequency = 0x80 | FGCommand_Frequency,

    // special
    FGCommand_Reset = 0xff,  
    
} enumFGCommand;


// Characteristics
#define CHARACTERISTICS_UUID_RESET              0xA100
#define CHARACTERISTICS_UUID_DEVICE             0xA101
#define CHARACTERISTICS_UUID_OUTPUT             0xA102
#define CHARACTERISTICS_UUID_FREQUENCY          0xA103
#define CHARACTERISTICS_UUID_WAVEFORMINFO       0xA110
#define CHARACTERISTICS_UUID_WAVEFORMBLOCK      0xA111
#define CHARACTERISTICS_UUID_WAVEFORMTOBUFFER   0xA112

//---------------------------------------------------------
#pragma pack(1)
// for BLE waveform transfer format

typedef struct {
    uint16_t    waveSize;       // Waveform全体のデータ長(byte)  = blockSize * blockMaxNum
    uint8_t     bitPerData;     // 1データあたりのbit数 (8, 10, 12 or 16bit)

    uint8_t     blockSize;      // 1ブロックあたりのデータ転送サイズ(byte) (通常16bytes)
    uint8_t     blockMaxNum;    // ブロックの最大数  = (waveSize + 1) / blockSize
} WaveformInfo, FGCommandWaveformInfo;

typedef struct {
    uint16_t   blockNo;     // ブロックNo. 0 〜 (WaveformInfo.blockMaxNum - 1)
    uint8_t    length;      // WaveformBlock.bufferの有効な長さ
    uint8_t    buffer[FGC_BUFFERTRANSFER_MAX];  // 実際のデータ
} WaveformBlock, FGCommandWaveformBlock;

//---------------------------------------------------------
// for I2C packet format

// header
typedef struct {
    uint8_t     command;
    uint8_t     length;
} FGHeader;

// command bodys
typedef struct {
    uint8_t    device;
} FGCommandDevice;

typedef struct {
    uint8_t    on;
} FGCommandOutput;

typedef struct {
    uint32_t   frequency;
} FGCommandFrequency;

//#define FGCommandWaveformInfo  WaveformInfo
//#define FGCommandWaveformBlock WaveformInfoBlock

typedef struct {
} FGCommandWaveformToBuffer;

typedef struct {
} FGCommandReset;

// status bodys
typedef struct {
    uint8_t    device;
} FGStatusDevice;

typedef struct {
    uint8_t    xxx;
} FGStatusOutput;

typedef struct {
    uint8_t    xxx;
} FGStatusFrequency;



// command Packet format
typedef struct {
    FGHeader    header;
    union {
        FGCommandDevice             commandDevice;
        FGCommandOutput             commandOutput;
        FGCommandFrequency          commandFrequency;
        FGCommandWaveformInfo       commandWaveformInfo;
        FGCommandWaveformBlock      commandWaveformBlock;
        FGCommandWaveformToBuffer   commandWaveformToBuffer;

        FGCommandReset           commandReset;

        FGStatusDevice           statusDevice;
        FGStatusOutput           statusOutput;
        FGStatusFrequency        statusFrequency;
    } body;
} FGPacket;

#pragma pack()
