//--------------------------------------------------------------
/**
 * FFT experiment for LPC1114FN28
 *
 * programed by Takehisa Oneta(ohneta)
 * Aug. 2015
 */
//--------------------------------------------------------------

#include "fftReal.hpp"
#include "mbed.h"

#define     SAMPLING_NUM    64
//#define     SAMPLING_NUM    32
//--------------------------------------------------------------

Serial pc(USBTX, USBRX);
AnalogIn  ainR(dp9);
AnalogIn  ainL(dp10);
Ticker soundInterrupt;

const char *gBarGraf[] = {
    "                               ",
    "*                              ",
    "**                             ",
    "***                            ",
    "****                           ",
    "*****                          ",
    "******                         ",
    "*******                        ",
    "********                       ",
    "*********                      ",
    "**********                     ",
    "***********                    ",
    "************                   ",
    "*************                  ",
    "**************                 ",
    "***************                ",
    "****************               ",
    "*****************              ",
    "******************             ",
    "*******************            ",
    "********************           ",
    "*********************          ",
    "**********************         ",
    "***********************        ",
    "************************       ",
    "*************************      ",
    "**************************     ",
    "***************************    ",
    "****************************   ",
    "*****************************  ",
    "****************************** ",
    "*******************************",
};

//--------------------------------------------------------------


uint32_t  gSoundIntrFlag = 0;
uint32_t  gSoundIntrCount = 0;

float  gBufferR[SAMPLING_NUM];
float  gBufferL[SAMPLING_NUM];

//----------------------------------------------------
/**
 * Ticker handler
 */
void soundInterruptHandle()
{
    if (gSoundIntrFlag == 0) {
        gSoundIntrFlag = 1;
    }
}

//----------------------------------------------------

int main()
{
    pc.baud(115200);
 
    Complex y1[SAMPLING_NUM / 2 + 1];
    Complex y2[SAMPLING_NUM / 2 + 1];

    pc.printf("### START \n");

    gSoundIntrFlag = 0;
    gSoundIntrCount = 0;
    uint32_t intr_us = 25;  //
    soundInterrupt.attach_us(&soundInterruptHandle, intr_us);

float dd = 20.0f;

    FftReal fft(SAMPLING_NUM);
    while (1) {
        
        if (gSoundIntrFlag == 1) {
            float r = ainR;
            float l = ainL;
            
            //pc.printf("*** [%02d] = %8.4f : %8.4f \n", gSoundIntrCount, r,  l);

            gBufferR[gSoundIntrCount] = r * dd - 1.0f;
            if (gBufferR[gSoundIntrCount] < -1.0f) {
                gBufferR[gSoundIntrCount] = -1.0f;
            } else if (gBufferR[gSoundIntrCount] > 1.0f) {
                gBufferR[gSoundIntrCount] = 1.0f;
            }
            gBufferL[gSoundIntrCount] = l * dd - 1.0f;
            if (gBufferL[gSoundIntrCount] < -1.0f) {
                gBufferL[gSoundIntrCount] = -1.0f;
            } else if (gBufferL[gSoundIntrCount] > 1.0f) {
                gBufferL[gSoundIntrCount] = 1.0f;
            }
            //pc.printf("*** [%02d] = %2.4f : %2.4f : %2.4f : %2.4f \n", gSoundIntrCount, r, l, gBufferR[gSoundIntrCount], gBufferL[gSoundIntrCount]);
            //pc.printf("\n");
 
            gSoundIntrCount++;
            if (gSoundIntrCount >= SAMPLING_NUM) {
                gSoundIntrCount = 0;

                fft.Execute(gBufferR, y1);
                fft.Execute(gBufferL, y2);

                //pc.printf("%c[2J%c[;H", 27, 27);
                pc.printf("%c[%c;%cH", 27, 0, 0);
                //pc.printf("%c[;H", 27);


                pc.printf("    [Right]                           [Left]\r\n");
                for (int n = 0; n <= (SAMPLING_NUM / 2); n++) {
                    uint32_t dtR = (uint32_t)abs(y1[n]);
                    if (dtR >= (SAMPLING_NUM / 2)) {
                        dtR = 15;
                    }
                    
                    uint32_t dtL = (uint32_t)abs(y2[n]);
                    if (dtL >= (SAMPLING_NUM / 2)) {
                        dtL = 15;
                    }

                    pc.printf("%2d: %s : %s\r\n", n, gBarGraf[dtR], gBarGraf[dtL]);
                }

           }
           gSoundIntrFlag = 0;
        }
   }

}

//----------------------------------------------------
