#include "mbed.h"
#include "AD9850.h"
#include "BLEDevice.h"

#define DEBUG 1

//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
Ticker ticker;
Serial		pc(P0_9, P0_11);
DigitalOut  led1(P0_18);
DigitalOut  led2(P0_19);
DigitalIn   btn1(P0_16);
DigitalIn   btn2(P0_17);

AD9850 dds(P0_20, P0_25, P0_24, P0_23);

//-----------------------------------------------------------------------

uint32_t targetFreq		= 10 * 1000 * 1000; // 10MHz - default
uint32_t incrementFreq	= 100 * 1000;		// This is a 100KHz frequency increment

//-----------------------------------------------------------------------

BLEDevice  ble;

const static char     DEVICE_NAME[] = "DDS-CTRL 0.2";
static const uint16_t uuid16_list[] = {0xFFFF};     // Custom UUID, FFFF is reserved for development

// Set Up custom Characteristics
static uint8_t      deviceValue = 0;
static uint8_t      outputValue = 0;
static uint32_t		frequencyValue = 0;

ReadWriteArrayGattCharacteristic<uint8_t, 1>    deviceChar(0xA201,    &deviceValue);
ReadWriteArrayGattCharacteristic<uint8_t, 1>    outputChar(0xA202,    &outputValue);
ReadWriteArrayGattCharacteristic<uint32_t, 1> 	frequencyChar(0xA203, &frequencyValue);

// Set up custom service
GattCharacteristic *characteristics[] = {
    &deviceChar,
    &outputChar,
    &frequencyChar,
};
GattService customService(0xA001, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));


//-----------------------------------------------------------------------
/**
 *
 */
 void connectionCallback(Gap::Handle_t Handle_t,
                         Gap::addr_type_t peerAddrType, const Gap::address_t peerAddr,
                         Gap::addr_type_t ownAddrType,  const Gap::address_t ownAddr,
                         const Gap::ConnectionParams_t *params)
{
    pc.printf("connectionCallback\n");
}

//--------------------------------
/*
 *  Restart advertising when phone app disconnects
 */ 
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    pc.printf("disconnectionCallback\n");
    ble.startAdvertising(); 
}

//--------------------------------
/* 
 *  handle writes to writeCharacteristic
 */
void writeCharCallback(const GattCharacteristicWriteCBParams *params)
{
    led2 = !led2;

	pc.printf("BLE:onDataWritten\n");

    if (params->charHandle == deviceChar.getValueHandle()) {
        memcpy(&deviceChar, params->data, params->len);
        pc.printf("deviceChar\n");
        pc.printf("deviceChar: deviceValue: %x\n", deviceValue);

    } else
    if (params->charHandle == outputChar.getValueHandle()) {
        memcpy(&outputValue, params->data, params->len);
        pc.printf("outputChar : outputValue: %x\n", outputValue);

    } else
    if (params->charHandle == frequencyChar.getValueHandle()) {
        memcpy(&targetFreq, params->data, params->len);
        pc.printf("frequencyChar\n");
        pc.printf("targetFreq: %d\n", targetFreq);
    }

}

//-----------------------------------------------------------------------

void tickerCallback()
{
    led1 = !led1;
}

char guruguru(int cnt)
{
	static char gurus[] = {'-', '\\', '|', '/'};
	return gurus[cnt % 4];
}

//--------------------------------

int main(void)
{
    ticker.attach(&tickerCallback, 0.5);

    pc.baud(115200);
    pc.printf("\n");
	pc.printf("------------------------\n");
	pc.printf("DDS-CTRL start\n");
	led1 = 0; led2 = 0;;


    ble.init();
    ble.onConnection(connectionCallback);
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(writeCharCallback);
		
	// setup advertising
    {
        // BLE only, no classic BT
        ble.accumulateAdvertisingPayload(   GapAdvertisingData::BREDR_NOT_SUPPORTED | 
                                            GapAdvertisingData::LE_GENERAL_DISCOVERABLE );
        // advertising type
        ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
        // add name
        ble.accumulateAdvertisingPayload(   GapAdvertisingData::COMPLETE_LOCAL_NAME, 
                                            (uint8_t *)DEVICE_NAME, 
                                            sizeof(DEVICE_NAME) );
        // UUID's broadcast in advertising packet
        ble.accumulateAdvertisingPayload(   GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS,
                                            (uint8_t *)uuid16_list,
                                            sizeof(uuid16_list) );
        ble.setAdvertisingInterval(100); // interval is 100ms. 
        // add my service
        ble.addService(customService);

        // start advertising
        ble.startAdvertising();
    }
	pc.printf("BLE init\n");


	// DDS 初期化
	{
		dds.init();
pc.printf("\nFREQ: %d [default]\n", targetFreq);
	    dds.setFrequency(targetFreq, 0, 0);
	    dds.setFrequency(targetFreq, 0, 0);
			// TODO: なぜか最初だけ２回ださないと設定されない... 
	}
	pc.printf("DDS init\n");


	int loopCounter = 0;
	int lastFreq = targetFreq;
    while (true) {
        ble.waitForEvent();

		loopCounter++;
		//pc.putc(guruguru(loopCounter));
		//pc.putc('\r');
		pc.putc('*');
		wait_ms(100);

		if (lastFreq != targetFreq) {
pc.printf("\nFREQ: %d\n", targetFreq);
        	dds.setFrequency(targetFreq, 0, 0);

			//gInternalStorageBuffer.freq = targetFreq;
			//nRF51822_internalStorage_write();

			lastFreq = targetFreq;
		}
	}

}

//---------------------------------------------------------

