#ifndef STATE_MACHINES_H
#define STATE_MACHINES_H

#include "mbed.h"
#include <stdint.h>

//#define DLVV
#define SAMPLING//commenter pour désactiver
#define DUMP_SAMPLIG_PERIOD 10000
#define DEBUG -1//-1 pour avoir uniquement la gestion de l'interruption bouton

#define NB_INTEGRAL_SAMPLES 20

#define TACHY_CM 8.0 // distance arbre
#define COEF_RAYON_BR_S_DIST 1
//#define FREINAGE_ADAPTATIF
#define PUISSANCE_FREINAGE_W 1000 //en W
#define MASSE_BINIOU_KG 1.8
#define DEMI_LARGEUR_BINIOU_CM 10.0

#define DIRECTION_PERIOD_MS 10000
#define DIRECTION_PULSE_MAX 2100
#define DIRECTION_PULSE_MIN 800
#define DIRECTION_PULSE_MIDDLE 1530

#define DIST_MIN_LONG_CM 40

#define SPEED_PERIOD_US 20000
#define BRAKING_PULSE_US 1350
#define MAX_PULSE_WIDTH_FOR_TACHY_US 1850
#define INITAL_PULSE_SPEED_US 1590
#define ZERO_PULSE_SPEED_US 1500

#define NB_ECHANTILLONS_IR 8

#define LIDAR_STRENGTH_THRESOLD 25 //pour la gestion de la vitesse MAX (MAXSpeed_ST)
#define LIDAR_ERR 65535

#define SPEED_DELTA_CMPS 30

#define CAPT_45_DROITE PC_2
#define CAPT_45_GAUCHE PA_4
#define CAPT_90_DROITE PA_1
#define CAPT_90_GAUCHE PC_1
#define CAPT_90_GAUCHE_SHORT PC_0
#define CAPT_90_DROITE_SHORT PA_0
#define CAPT_10_GAUCHE PB_0
#define CAPT_10_DROITE PC_3
#define CAPT_DEVANT    PC_3
#define ODOMETRE       PA_11

#ifdef SAMPLING
#define TAILLE_SAMPLES 1600
typedef struct states
{
    char murs_dlvv;
    char section;
    char maxSpeed;
    char throttle;
    }s_States;

typedef struct sample
{
    s_States states;
    int time;
    int16_t pwm_thro_us;
    int16_t pwm_dir_us;
    double largeurPiste;
    double position45;
    double position90;
    double dist;
    int16_t distLidar;
    int16_t strLidar;
} s_Sample;

#endif

typedef enum{
    REF_BIDIR,
    REF_A_DROITE,
    REF_A_GAUCHE
}MUR_ST;

#ifdef DLVV
typedef enum{//uniquement activé pour dlvv, se rajoute au PID de murOutput
    ALL_CLEAR,
    FRONT_OBSTRUCTED,//pas d'obstacle droit devant
    RIGHT_OBSTRUCTED,//un obstacle à été detecté à gauche
    LEFT_OBSTRUCTED//un obstacle à été detecté à droite
}OBSTACLE_ST;
#endif

typedef enum{
    ARRET,
    LOADING_SECTION,
    RUNNING_SECTION
}SECTION_ST;

typedef enum{
    SPEED_MAX,//pas de mur, on va a fond
    SPEED_WARNING,//signal suffisement fort pour gérer la vitesse
    BLOCKED//nous somme dans la plage de distance ou la vitesse doit être limitée
}MAX_SPEED_ST;

typedef enum{
    REGULATION_SPEED,
    AT_SPEED,
    BRAKING,
    STOPPED
}THROTTLE_ST;


typedef struct s_section {
   double targetSpeed_cmps;//supérieure a 328
   double slowSpeed_cmps;//supérieure a 328; pour effectuer les virages: pour ne pas avoir d'a coups entre la vitesse variable et la vitesse limitée
   double coef_p_speed;
   double consigne_position;
   double lidarWarningDist_cm;
   double lng_section_cm;
   // coef
   double coef_pd45;
   double coef_pg45;
   double coef_pd90;
   double coef_pg90;
    //
    double coef_dd45;
    double coef_dg45;
    double coef_dd90;
    double coef_dg90;
    
   double coef_i45;
   double coef_i90;
   s_section* nextSection;
}s_Section;

//*************** fonctions utilitaires ***************

//void getTachySpeed();
double getDistMoy(AnalogIn* p, double *tab, int size);
void it4cm();
void it_serial();
void sampleLog();
void initSamples();
void initIntegrationTable();
void pressed();


//*************** fonctions states machines ***************
//gestion de la direction quand la vue est dégagée
void mursInit(void);
void mursUpdate(void);
void mursOutput(void);

#ifdef DLVV
//gestion de la direction en mode course et de l'évitement en mode DLVV
void obstacleInit(void);
void obstacleUpdate(void);
void obstacleOutput(void);
#endif

//gestion du comportement en fn de l'avancement sur le parcours
void sectionInit(void);
void sectionUpdate(void);
void sectionOutput(void);

//gestion de la gesion de la vitesse max/rotation max des roues la rotation est plus importante que la vitesse :)
void maxSpeedInit(void);
void maxSpeedUpdate(void);
void maxSpeedOutput(void);

//gestion de l'allure en fonction des paramètres de la section
void throttleInit(void);
void throttleUpdate(void);
void throttleOutput(void);

#endif
