#include "stateMachines.h"

Timer timerLoop;
#if DEBUG >= -1
InterruptIn dump_button(USER_BUTTON);
#endif

int main()
{
#if DEBUG >= -1
    dump_button.fall(&pressed);
    initSamples();
#endif
    initIntegrationTable();
    mursInit();
#ifdef DLVV
    obstacleInit();
#endif
    sectionInit();
    maxSpeedInit();
    throttleInit();
    timerLoop.start();
    while (1) {
        if(timerLoop.read_us()>20000) { // output every 20 ms
            timerLoop.reset();
            timerLoop.start();
            mursUpdate();
#ifdef DLVV
            obstacleUpdate();
#endif

            sectionUpdate();
            maxSpeedUpdate();
            throttleUpdate();


            mursOutput();
#ifdef DLVV
            obstacleOutput();
#endif
            sectionOutput();
            maxSpeedOutput();
            throttleOutput();
        }
#ifdef SAMPLING
        sampleLog();
#endif

    }
}
