#include "mbed.h"
#include "ATParser.h"
#include "string.h"
#include <string>


Serial pc(USBTX, USBRX); //((USBTX, USBRX))
Serial modbus(PA_9, PA_10,9600);//(tx,rx,baud)
//Serial evk(PC_10,PC_11,115200); //CN7
BufferedSerial evk(PC_10,PC_11,1024);
ATParser at=ATParser(evk,"\r\n");

DigitalOut DE_RE(PA_8);

int Max_Byte=8;
uint8_t mdb_Command_buffer[11];
uint8_t mdb_Message_buffer[8];
uint16_t RTU_CRC; 
int message_in_byte=0;
char device_counter=1;
int D3_X0 = 0;
int D1_X0 = 0;
char server_buff[27]={0};
        

void AT_publish(char* s);

struct mdb_Data_Set {
    uint8_t Addr;
    uint8_t Data[8];
};
mdb_Data_Set mdb_Data[8]; 

//MODBUS RTU CRC  
uint16_t mdbRTU_CRC(uint8_t message[], int Length)  
{
    RTU_CRC=0xffff;
    for (int pos =0 ; pos < Length ; pos++)
    {
        RTU_CRC ^= (uint16_t)message[pos];
        
        for (int i = 8; i != 0; i--)
        {
            if ((RTU_CRC & 0x0001) != 0)
                {
                    RTU_CRC >>= 1;
                    RTU_CRC ^= 0xA001;
                }
            else
                RTU_CRC >>= 1;
        }  
    }
    return RTU_CRC;
    //pc.printf("hi_mdb_CRC= %02X \r\n", hi_RTU_CRC);
    //pc.printf("lo_mdb_CRC= %02X \r\n", lo_RTU_CRC);
}  

//char to int

int char_to_int(char high,char low){
    int H = high - 48;
    int L = low - 48;
    int K = H*10 + L -30;
    
    if(K == 31) return 10;
    else if(K == 32) return 11;
    else if(K == 33) return 12;
    else if(K == 34) return 13;
    else if(K == 35) return 14;
    else if(K == 36) return 15;
    else return K;
    }


//write modbus_data
void mdb_control(uint8_t action){
        int dev_Addr = 0; 
        int command_length=0;
        uint8_t hi_RTU_CRC ;
        uint8_t lo_RTU_CRC ;
        
        
        switch(action){
            
            case 1:
            dev_Addr = 1;
            pc.printf("Device 1 task 1 : Read X0~X7 \n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x01;
            mdb_Command_buffer[1]=(uint8_t) 0x02;
            mdb_Command_buffer[2]=(uint8_t) 0x04;
            mdb_Command_buffer[3]=(uint8_t) 0x10;
            mdb_Command_buffer[4]=(uint8_t) 0x00;
            mdb_Command_buffer[5]=(uint8_t) 0x08;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            case 2:
            dev_Addr = 1;
            pc.printf("Device 1 task2 : Y3 change state every 5 seconds \n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x01;
            mdb_Command_buffer[1]=(uint8_t) 0x01;
            mdb_Command_buffer[2]=(uint8_t) 0x05;
            mdb_Command_buffer[3]=(uint8_t) 0x03;
            mdb_Command_buffer[4]=(uint8_t) 0x00;
            mdb_Command_buffer[5]=(uint8_t) 0x01;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            case 3:
            dev_Addr = 1;
            pc.printf("Device 1 task 3 : Read D0 which add 1 per second \n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x01;
            mdb_Command_buffer[1]=(uint8_t) 0x03;
            mdb_Command_buffer[2]=(uint8_t) 0x10;
            mdb_Command_buffer[3]=(uint8_t) 0x00;
            mdb_Command_buffer[4]=(uint8_t) 0x00;
            mdb_Command_buffer[5]=(uint8_t) 0x01;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            case 4:
            dev_Addr = 1;
            if(D1_X0==0)pc.printf("Device 1 task 4 : Set X0 ON\n");
            else pc.printf("Device 1 task 4 : Set X0 OFF\n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x01;
            mdb_Command_buffer[1]=(uint8_t) 0x05;
            mdb_Command_buffer[2]=(uint8_t) 0x05;
            mdb_Command_buffer[3]=(uint8_t) 0x00;
            if(D1_X0==0)mdb_Command_buffer[4]=(uint8_t) 0xFF;
            else mdb_Command_buffer[4]=(uint8_t) 0x00;            
            mdb_Command_buffer[5]=(uint8_t) 0x00;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            case 5:
            dev_Addr = 1;
            pc.printf("Device 1 task 4 : Read Y0 \n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x01;
            mdb_Command_buffer[1]=(uint8_t) 0x02;
            mdb_Command_buffer[2]=(uint8_t) 0x04;
            mdb_Command_buffer[3]=(uint8_t) 0x00;
            mdb_Command_buffer[4]=(uint8_t) 0x00;            
            mdb_Command_buffer[5]=(uint8_t) 0x08;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            case 6:
            dev_Addr = 2;
            pc.printf("Device 2 : Voltage  \n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x02;
            mdb_Command_buffer[1]=(uint8_t) 0x03;
            mdb_Command_buffer[2]=(uint8_t) 0x01;
            mdb_Command_buffer[3]=(uint8_t) 0x06;
            mdb_Command_buffer[4]=(uint8_t) 0x00;
            mdb_Command_buffer[5]=(uint8_t) 0x02;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            case 7:
            dev_Addr = 3;
             if(D3_X0==0)pc.printf("Device 3 : Set X0 ON\n");
            else pc.printf("Device 3 : Set X0 OFF\n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x03;
            mdb_Command_buffer[1]=(uint8_t) 0x05;
            mdb_Command_buffer[2]=(uint8_t) 0x05;
            mdb_Command_buffer[3]=(uint8_t) 0x00;
            if(D3_X0==0)mdb_Command_buffer[4]=(uint8_t) 0xFF;
            else mdb_Command_buffer[4]=(uint8_t) 0x00;            
            mdb_Command_buffer[5]=(uint8_t) 0x00;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            case 8:
            dev_Addr = 3;
            pc.printf("Device 3 : Read Y0 \n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x03;
            mdb_Command_buffer[1]=(uint8_t) 0x02;
            mdb_Command_buffer[2]=(uint8_t) 0x04;
            mdb_Command_buffer[3]=(uint8_t) 0x00;
            mdb_Command_buffer[4]=(uint8_t) 0x00;            
            mdb_Command_buffer[5]=(uint8_t) 0x08;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            case 9:
            dev_Addr = 5;
            pc.printf("Device 5 : Read Temperature \n");
            command_length = 8;
            //pc.printf("\nRead from device %d at %04x with length %04x\n",dev_Addr,Hold_Reg,Reg_len);
            mdb_Command_buffer[0]=(uint8_t) 0x05;
            mdb_Command_buffer[1]=(uint8_t) 0x03;
            mdb_Command_buffer[2]=(uint8_t) 0x10;
            mdb_Command_buffer[3]=(uint8_t) 0x00;
            mdb_Command_buffer[4]=(uint8_t) 0x00;
            mdb_Command_buffer[5]=(uint8_t) 0x01;
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            break;
            
            default:
            command_length = 0;
            pc.printf("there is no action in mdb_ctrol");
            break;
            }
            
            // put command_buffer to modbus
            DE_RE=1;
           
            int byte_of_buffer;
            for (byte_of_buffer=0 ; byte_of_buffer<command_length ; byte_of_buffer++)
                {
                    modbus.putc(mdb_Command_buffer[byte_of_buffer]);
                }
            
            wait_ms(2);
            message_in_byte=0;
            DE_RE =0 ;
            wait_ms(80);        
            int data_len=(int)(mdb_Message_buffer[2]);
            RTU_CRC=mdbRTU_CRC(mdb_Message_buffer,data_len+3);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            if ((mdb_Message_buffer[data_len+3]==lo_RTU_CRC)&&(mdb_Message_buffer[data_len+4]==hi_RTU_CRC))
            {
                for (int i=0 ; i<data_len ; i++)
                    {
                        mdb_Data[(dev_Addr)].Data[i]=mdb_Message_buffer[i+3];
                        pc.printf("mdb_Data= %02x\r\n",mdb_Data[(dev_Addr)].Data[i]);
                        char _buff[13];
                        sprintf((char*)_buff,"mdb_Data= %02x",mdb_Data[(dev_Addr)].Data[i]);
                        char buff[4];
                        sprintf((char*)buff,"%d,%02x",dev_Addr,mdb_Data[(dev_Addr)].Data[i]);
                            
                    }
            }
        
    }


//put PC input into modbus 
void PC_callback() {
    //modbus.putc(pc.getc());
   // char incomming_CMD;
  /*  while (pc.readable()){
        incomming_CMD+=pc.getc()-1;
        }
    pc.printf("Received Command :%c\r\n", incomming_CMD);*/
    
  //  evk.putc(pc.getc());
  
/*  if(pc.readable()){
     ch=pc.getc();
     at_cmd[index++]=ch;
      }
  at_cmd[index]='\x0';
  pc.printf(at_cmd);*/
  if(pc.readable()){
        char at_cmd[100];
        int index=0;
        char ch;
        do{
           ch=pc.getc();
           at_cmd[index++]=ch;
           pc.printf(at_cmd);
        }while(ch!='\n');
             
         at_cmd[index]='\x0';
         pc.printf(at_cmd);
         AT_publish(at_cmd);
            
    //pc.putc(pc.getc());
    }
        
} 

void evk_callback() {
 /*   int counter=0;
    char ch;
    char evk_buff[300];
    while(evk.readable()){
        ch=at.getc();
        evk_buff[counter]=ch;
        counter++;
        }
    evk_buff[counter]='\x0';
    if(strncmp(evk_buff,"AT+UUSORD",9)==1){
        
        }
    else pc.printf(evk_buff); */
    //pc.putc(evk.getc());
    //int callback_len=0;
    //if(at.recv("AT+USORD=0,%d",&callback_len))pc.printf(&callback_len);
} 


//put modbus reply into PC
void MODBUS_callback() {
    //pc.putc(modbus.getc());
    mdb_Message_buffer[message_in_byte]=modbus.getc();
    message_in_byte++;
    
}

void AT_publish(char* s){
    if(at.send("AT+UMQTTC=2,0,0,\"nbiot/gw\",\"%s\"",s)
    )pc.printf("Send \"%s\" to MQTT server\r\n",s);
    else pc.printf("Send \"%s\" to Server Failed !\r\n",s);    
    at.flush();
    wait_ms(10);
    }



int main() {
    pc.baud(115200);
    evk.baud(115200);
    at.setTimeout(6000);
    
    
    //evk.attach(&evk_callback);
    pc.attach(&PC_callback);
    modbus.attach(&MODBUS_callback);
    
    server_buff[2]=';';
    server_buff[4]=';';
    server_buff[11]=';';
    server_buff[13]=';';
    server_buff[20]=';';
    server_buff[22]=';';  
    
    
       //=========TEST AT=============
    if(at.send("AT")&& at.recv("AT")&&at.recv("OK")){
        pc.printf("AT OK\n");
    //  evk.printf("AT OK");
         }
    else pc.printf("AT NO OK\n");
    wait_ms(3000);
    //========SET MQTT IP============
    if(at.send("AT+UMQTT=3,\"140.114.78.141\"")  && at.recv("AT+UMQTT=3,\"140.114.78.141\"")  && at.recv("+UMQTT: 3,1")  && at.recv("OK")) pc.printf("Set IP OK\n");
    else pc.printf("IP NO OK\n");
    //========CONNECT TO MQTT SERVER=======
    if(at.send("AT+UMQTTC=1") && at.recv("AT+UMQTTC=1") && at.recv("+UMQTTC: 1,1") && at.recv("OK") && at.recv("+UUMQTTC: 1,0"))pc.printf("Connected to MQTT Server\n");
    else pc.printf("Connect to Server failed !\n");
    //========SEND MESSAGE =============
    if(at.send("AT+UMQTTC=2,0,0,\"nbiot/gw\",\"HELLO Send From F466RE,466924700006098\"") 
    && at.recv("AT+UMQTTC=2,0,0,\"nbiot/gw\",\"HELLO Send From F466RE,466924700006098\"")
    && at.recv("+UMQTTC: 2,1") 
    && at.recv("OK"))pc.printf("Send Hello to MQTT Server\r\n");
    else pc.printf("Send Message to Server Failed !\n");
    
    while(1) {
        for(int i=1;i<10;i++){
                mdb_control(i);
                if(i==1){
                    char buff[2];

                    sprintf((char*)buff,"%02x",mdb_Data[1].Data[0]);  
                    pc.printf("%02x\r\n",mdb_Data[1].Data[0]);
                    server_buff[0]=buff[0];
                    server_buff[1]=buff[1];            
                    }
                    
                if(i==2){
                    if(mdb_Data[1].Data[0]==0x02){
                         server_buff[3]='0';
                         pc.printf("Y3 OFF\r\n");                      
                        }
                    else {
                         server_buff[3]='1';
                         pc.printf("Y3 ON\r\n");
                        }                        
                    }
                    
                else if(i==3){
                    uint16_t data = ((((uint16_t)(mdb_Data[1].Data[0]))<<8) | (uint16_t)(mdb_Data[1].Data[1]));
                    pc.printf("counter = %04X(hex) , %d(int)\r\n\n",data,data);
                    
                    char buff[6];
                    
                    sprintf((char*)buff,"%6d",data);
                    server_buff[5]=buff[0];
                    server_buff[6]=buff[1];
                    server_buff[7]=buff[2];
                    server_buff[8]=buff[3];
                    server_buff[9]=buff[4];
                    server_buff[10]=buff[5];                                        
                    }
                else if(i==5){
                                        
                    if(mdb_Data[1].Data[0]==0x00){
                         server_buff[12]='0';
                         pc.printf("D1_Y0 OFF\r\n");                      
                        }
                    else {
                         server_buff[12]='1';                        
                         pc.printf("D1_Y0 ON\r\n");
                        }                        
                    }
                    
                else if(i==6){
                    int voltage = (((uint32_t)(mdb_Data[2].Data[0]))<< 8) | (((uint32_t)(mdb_Data[2].Data[1]))) | (((uint32_t)(mdb_Data[2].Data[2]))<< 24) | (((uint32_t)(mdb_Data[2].Data[3]))<< 16);
                    float *pf=(float*)&voltage;
                    //printf("%f",*pf);
                    pc.printf("voltage = %08x(hex) %.2f(float)\r\n",voltage,*pf);
                    int a = *pf*100;
                    pc.printf("a = %d\r\n",a);
                    char buff[5];                    
                    sprintf(buff,"%5d",a);
                    pc.printf("buff = %02x%02x%02x%02x%02x\r\n",buff[0],buff[1],buff[2],buff[3],buff[4]);
                    server_buff[14]=buff[0];
                    server_buff[15]=buff[1];
                    server_buff[16]=buff[2];
                    server_buff[17]='.';
                    server_buff[18]=buff[3];
                    server_buff[19]=buff[4];                  
                    }
                    if(i==8){
                                           
                            if(mdb_Data[3].Data[0]==0x00){
                                 server_buff[21]='0';
                                 pc.printf("D3 Y0 OFF\r\n");                      
                                }
                            else {
                                 server_buff[21]='1';
                                 pc.printf("D3 Y0 ON\r\n");
                                }
                                
                    }
                    
                else if(i==9){
                    uint16_t temperature = ((((uint16_t)(mdb_Data[5].Data[0]))<<8) | (uint16_t)(mdb_Data[5].Data[1]));
                    pc.printf("temperature = %04x(hex),%d(int)\r\n",temperature,temperature);          
                    
                    char buff[3];
                    
                    sprintf(buff,"%3d",temperature);
                    server_buff[23]=buff[0];
                    server_buff[24]=buff[1];
                    server_buff[25]='.';
                    server_buff[26]=buff[2];   
                    AT_publish(server_buff);                  
                    }
                    
                    
                pc.printf("============\r\n");
                wait_ms(50);
                
                }           
                
                        
        }           
}