#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include <string> 


EthernetNetIf eth; 
HTTPClient http;

// Ethernet LED's
DigitalOut RED(p29);
DigitalOut YEL(p30);

  
int main() {

    printf("Start\n");
    RED = !RED; YEL = !YEL;
    
    printf("\r\nSetting up...\r\n");
    RED = !RED; YEL=!YEL;
    
    EthernetErr ethErr = eth.setup();
    RED = !RED; YEL=!YEL;
    
    if(ethErr)
    {
    printf("Error %d in setup.\n", ethErr);
    return -1;
    }
    printf("\r\nSetup OK\r\n");
    RED = !RED; YEL=!YEL;
    
    HTTPText txt;
    RED = !RED; YEL=!YEL;
     
    int idx = 0;
    
    while(idx < 5) {
    
        printf("\r\n idx = %d \r\n",idx);
    
        // copy API key from settings
        char apiKey[17]= "L6MA5ZGH3WPSDALA";
        printf("apiKey = %s \r\n",apiKey); 
        
        // use feed ID
        char fieldID[8]= "field1";
        printf("fieldID = %s \r\n",fieldID); 
        
        // Send data based on the loop idx - this example is 0-4
        char data[10];
        sprintf(data,"%d",idx*10);
        printf("data = %s \r\n",data);
    	
    	// uri for post includes feed ID
        char uri[256];
        sprintf(uri,"%s%s&%s=%s","http://api.thingspeak.com/update?key=",apiKey,fieldID,data); 
        printf("uri = %s \r\n",uri); 
                                 
        // result should =  - "http://api.thingspeak.com/update?key=L6MA5ZGH3WPSDALA&field1=26"
        HTTPResult r = http.get(uri, &txt);
        RED = !RED; YEL=!YEL;
            
        if(r==HTTP_OK)
            {
            printf("Result :\"%s\"\n", txt.gets()); 
            }
            else
            {
            printf("Error %d\n", r);
            }
        RED = !RED; YEL=!YEL;
               
        wait(60); //wait 60 seconds
        idx = idx + 1;
    }
 
}