#include "mbed.h"
#include "rtos.h"
#include <math.h>
#define TS1 0.2
int q=0,START=15; //10
float ut1=0,ut2=0,usi=0;
float vt1=0,vt2=0,vsi=0;
float wt1=0,wt2=0,wsi=0;
float ui=0,vi=0,wi=0;
float su,sv,sw;
float PI=3.141592;
float t=2.26E-4; //2.26E-4
float Speed;
PwmOut mypwmA(PA_8); //PWM_OUT 8
PwmOut mypwmB(PA_9); //9
PwmOut mypwmC(PA_10);//10

DigitalOut EN1(PC_10);
DigitalOut EN2(PC_11);
DigitalOut EN3(PC_12);

InterruptIn  HA(PA_15);
InterruptIn  HB(PB_3);
InterruptIn  HC(PB_10);

AnalogIn V_adc(PC_2);  //Potention
//AnalogIn V_adc(PB_1);   // gaibu Volume
Timer uT;
Timer vT;
Timer wT;
AnalogOut SWAVE(PA_4);

Serial pc(USBTX,USBRX);

DigitalOut myled(LED1);

float Vr_adc=0.0f;
    
 void HAH(){
    ut1=uT.read_us(); 
    ui=0; 
      }
 void HAL(){
    ut2=uT.read_us(); 
    uT.reset(); 
     }
 void HBH(){
    vt1=vT.read_us();
    vi=0;
     }
 void HBL(){
    vt2=vT.read_us();
    vT.reset();
     }
 void HCH(){
    wt1=wT.read_us();
    wi=0;
     } 
 void HCL(){
    wt2=wT.read_us();
    wT.reset();
     }   
     
void CPLT(){
  pc.printf("%.3f , %.3f \r" ,Speed ,Vr_adc);
 }
     
void timerTS1(void const*argument){
   CPLT();
 }
 
 
int main() {
  
  pc.baud(128000); 
   
   EN1=1;
   EN2=1;
   EN3=1;
   
    mypwmA.period_us(20);
  
    mypwmB.period_us(20);
   
    mypwmC.period_us(20);
      
     uT.start();
     vT.start();
     wT.start();
     
     
     RtosTimer RtosTimerTS1(timerTS1);
     RtosTimerTS1.start((unsigned int)(TS1*3000));
     Thread::wait(100);
     
 while(1) {
      
      Vr_adc=V_adc.read();
      
if((Vr_adc>0.15f)&&(q==0)){ 
      
 while(q<50){   //30
    
    mypwmA.write(0.5f); //0.5
    mypwmB.write(0);
    mypwmC.write(0);
    wait_ms(START);
           
    mypwmA.write(0);
    mypwmB.write(0.5f);
    mypwmC.write(0);
    wait_ms(START);
         
    mypwmA.write(0);
    mypwmB.write(0);
    mypwmC.write(0.5f);
    wait_ms(START);
    q++;
    
    }
   // q=31;
    }
        
        HA.rise(&HAH);
        HC.fall(&HCL);
        HB.rise(&HBH);
        HA.fall(&HAL);
        HC.rise(&HCH);
        HB.fall(&HBL);
       
    if(Vr_adc < 0.05f){ 
          q=0;
            
       }    
            
        ui=ui+1;
        vi=vi+1;
        wi=wi+1;
           
         usi=ut2-ut1;
         vsi=vt2-vt1;
         wsi=wt2-wt1;
         
    if(q>=31){       
         
         su=sin(2*PI*((1/(2*usi*1E-6))*ui*t)); 
         sv=sin(2*PI*((1/(2*vsi*1E-6))*vi*t));
         sw=sin(2*PI*((1/(2*wsi*1E-6))*wi*t));

         }      
         
         mypwmA.write(su*Vr_adc); 
         mypwmB.write(sv*Vr_adc); 
         mypwmC.write(sw*Vr_adc); 
         
         SWAVE=su;
       
         Speed=60*(1/(7.0*2.0*usi*1E-6));    
         
        myled = !myled;
      
    }
}


