#include "mbed.h"
#include "C12832.h"
#include "Sht31.h"

DigitalOut blueled(p17, 0); // Initializing the yellow light OFF 
DigitalOut redled(p15, 0); // Initializing the red light OFF 
DigitalOut whiteled(p19, 0); // Initializing the red light OFF 
C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11); // create an instance of LCD
Sht31 sht31(I2C_SDA, I2C_SCL);
DigitalIn switchmode(p24);
InterruptIn button(p20);
int i=0;
int k=0;
int maxtopics=5;
int d=1;
Timer t;
time_t rise_seconds;
time_t fall_seconds;
int duration;
//initialize topics, summaries and welcome message
const char *myArray[5][2] = { { "ID", "ASSIGNING OF IDENTIFICATION CARDS TO CITIZENS" }, { "VISA", "PROVISIONING OF VISA TO FOREIGNERS" },
{"PASSPORT"," PASSPORT ASSIGNMENT TO APPLICANTS"},{ "BIRTH CERTIFICATE","APPLICATION OF BIRTH REGISTRATION"},
{"DRIVING LICENSES","APPLICATION AND PROVISIONING OF DRIVING LINCENCE"}};
 char welcome_message[]="Center for Government Services";

//function for displaying message
static void display(const char *message) {
    lcd.cls();  // Clear LCD
    lcd.locate(10, 5); // get cursor to position x=3px and y=5px
    lcd.printf(message); // Write text into LCD buffer
    lcd.copy_to_lcd();
}
void fallISR() {
    t.start();
    fall_seconds = time(NULL);
 }
void riseISR()
{
    t.stop();
    rise_seconds = time(NULL);
    duration = rise_seconds-fall_seconds; 
   //printf("\nthe duration is %d",duration); 
          if(duration>3)
    {
        d=d*-1;
    }
        i=i+d;
}
 //function to display topic and summary*/
void display_message(const char *topic,const char *summary, int i)
{
    
    display(topic);
    wait(1);
    display(summary); 
}
 //function for mode two
void Reading()
{
    while(switchmode)
    {
    if(d<0)
    {
    redled=1;
    blueled=0; 
     }
     else
     {
     blueled=1;
    redled=0;
     } 
    k=k+1;

    if(i==0 || i>4)
    {
        //in ascending order if i goes above 4 display myArray[0][0]
        //if i>4 make i =0
        i=0;
    }
    else if(i==4 || i<0 )
    //in descending order if i goes below zero display myArray[4][0]
    //if i<0 make i=4
    {
        i=4;
    }
    display_message(myArray[i][0],myArray[i][1],i);
    if(k>4)
    {
    printf("\n topic ID is=%d and reading duration is %d seconds",i,k);
    k=0;
    }
    wait(1);
    }
    !switchmode;

}
void looping()
    {    
        while(!switchmode)
        {
   i=0;
   time_t seconds = time(NULL);
    float temp = sht31.readTemperature(); //read temperature
    lcd.locate(5, 5); // get cursor to position x=5px and y=5px
    lcd.printf("Current Temperature: %.2fC",temp);//display temp
    lcd.locate(5, 5); // get cursor to position x=5px and y=5px
    lcd.printf("Current Time in seconds is: %d",(unsigned int)seconds); //display time
    //wait(3);
        while(i<maxtopics)
        {
            whiteled=1;
        //with the value of i, when you enter mode two you see summary of the topic displayed when you entered mode two
        display(myArray[i][0]);
        whiteled=0;
        i++;
        wait(2);
        }
        Reading();
        wait(1);
        }
        
    }

int main()
{
    set_time(1256729737);
    button.fall(&fallISR);
    button.rise(&riseISR);
    display(welcome_message);//show welcome message
    looping();
}
