#include "mbed.h"


SPI deviceM(PB_5, PB_4, PB_3);
DigitalOut ssel (PB_9);
Serial command(USBTX,USBRX);

#define FIG_C 0x01
#define FIG_I 0x02
#define FIG_L 0x03
#define FIG_T 0x04
#define FIG_S 0x05
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1);
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
};

void test()  //test
{
    sendSPI(0x0F,1);
    wait(0.5);
    sendSPI(0x0F,0);
    wait(0.5);    
};

void cuadro(int x,int y)
{
    int j;
    int cu[8]={0xC0,0x60,0x30,0x18,0xc,0x6,0x3,0x1};
    switch(y)
    {
         case 1: case1:
                for(j=0;j<=7;j++)
                {
                    sendSPI(0x0+j,cu[x-1]);
                    sendSPI(0x0+(j+1),cu[x-1]);
                    wait_ms(200);
                    sendSPI(0x0+j,0x00);
                    sendSPI(0x0+(j+1),0x00);
                    wait_us(10); 
                } 
                sendSPI(0x07,cu[x-1]);
                sendSPI(0x08,cu[x-1]);  
                break;
        case 2: goto case1;
        case 3: goto case1;
        case 4: goto case1;
    }                
};

void linea(int x,int y)
{
    int j;
    int lin0[8]={0x80,0x40,0x20,0x10,0x8,0x4,0x2,0x1};
    int lin90[8]={0b11100000,0b01110000,0b00111000,0b00011100,0b00001110,0b00000111,0b00000111,0b00000111};
    {
    switch (y){
        case 1:  case1: for(j=0;j<=6;j++)
             {
                sendSPI(0x0+j,lin0[x-1]);
                sendSPI(0x0+(j+1),lin0[x-1]);
                sendSPI(0x0+(j+2),lin0[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                sendSPI(0x0+(j+2),0x00);
                wait_us(10); 
            } 
                sendSPI(0x06,lin0[x-1]);
                sendSPI(0x07,lin0[x-1]);
                sendSPI(0x08,lin0[x-1]);  
                break;
        case 2: case2:   for(j=0;j<=7;j++)
             {
                sendSPI(0x0+j,lin90[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                wait_us(10); 
            } 
                sendSPI(0x08,lin90[x-1]);  
                break;           
        case 3:   goto case1;
        case 4:   goto case2;
    }
        
 }                
};

void ele(int x,int y)
{
    int j;
    int ele10[8]={0xc0,0x60,0x30,0x18,0xc,0x06,0x03,0x01};
    int ele20[8]={0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};
    int ele190[8]={0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0b00000001,0x00,0x00};
    int ele290[8]={0b11100000,0b01110000,0b00111000,0b00011100,0b00001110,0b00000111,0b00000011,0b00000001};
    int ele1180[8]={0b11000000,0b01100000,0b00110000,0b00011000,0b00001100,0b00000110,0b00000011,0b00000001};
    int ele2180[8]={0b01000000,0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0b00000001,0b00000000};
    int ele1270[8]={0b11100000,0b01110000,0b00111000,0b00011100,0b00001110,0b00000111,0b00000011,0b00000001};
    int ele2270[8]={0b10000000,0b01000000,0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0b00000001};
    switch(y)
    {
         case 1:
                for(j=0;j<=6;j++)
                {
                sendSPI(0x0+j,ele20[x-1]);
                sendSPI(0x0+(j+1),ele20[x-1]);
                sendSPI(0x0+(j+2),ele10[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                sendSPI(0x0+(j+2),0x00);
                wait_us(10); 
                } 
                sendSPI(0x06,ele20[x-1]);
                sendSPI(0x07,ele20[x-1]);
                sendSPI(0x08,ele10[x-1]);  
                break;
         case 2:
                for(j=0;j<=6;j++)
                {
                sendSPI(0x0+j,ele190[x-1]);
                sendSPI(0x0+(j+1),ele290[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                wait_us(10); 
                } 
                sendSPI(0x07,ele190[x-1]);
                sendSPI(0x08,ele290[x-1]);  
                break;
         case 3:
                for(j=0;j<=6;j++)
                {
                sendSPI(0x0+j,ele1180[x-1]);
                sendSPI(0x0+(j+1),ele2180[x-1]);
                sendSPI(0x0+(j+2),ele2180[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                sendSPI(0x0+(j+2),0x00);
                wait_us(10); 
                } 
                sendSPI(0x06,ele1180[x-1]);
                sendSPI(0x07,ele2180[x-1]);
                sendSPI(0x08,ele2180[x-1]);  
                break;
         case 4:
                for(j=0;j<=6;j++)
                {
                sendSPI(0x0+j,ele1270[x-1]);
                sendSPI(0x0+(j+1),ele2270[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                wait_us(10); 
                } 
                sendSPI(0x07,ele1270[x-1]);
                sendSPI(0x08,ele2270[x-1]);  
                break;
    }                
};

void te(int x,int y)
{
    int te10[8]={0x40,0x20,0x10,0x8,0x4,0x2,0x1,0x01};
    int te20[8]={0xe0,0x70,0x38,0x1c,0xe,0x7,0x03,0x01};
    int te190[8]={0b10000000,0b01000000,0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0b00000001};
    int te290[8]={0b11000000,0b01100000,0b00110000,0b00011000,0b00001100,0b00000110,0b00000011,0b00000001};
    int te1180[8]={0b11100000,0b01110000,0b00111000,0b00011100,0b00001110,0b00000111,0b00000011,0b00000001};
    int te2180[8]={0b01000000,0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0b00000001,0b00000000};
    int te1270[8]={0b01000000,0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0b00000001,0b00000000};
    int te2270[8]={0b11000000,0b01100000,0b00110000,0b00011000,0b00001100,0b00000110,0b00000011,0b00000001};
    int j;
    
    switch(y)
        {
         case 1:
            for(j=0;j<=7;j++)
             {
                sendSPI(0x0+j,te10[x-1]);
                sendSPI(0x0+(j+1),te20[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                wait_us(10); 
            } 
                sendSPI(0x07,te10[x-1]);
                sendSPI(0x08,te20[x-1]); 
                break; 
         case 2:
            for(j=0;j<=6;j++)
             {
                sendSPI(0x0+j,te190[x-1]);
                sendSPI(0x0+(j+1),te290[x-1]);
                sendSPI(0x0+(j+2),te190[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                sendSPI(0x0+(j+2),0x00);
                wait_us(10); 
            } 
                sendSPI(0x06,te190[x-1]);
                sendSPI(0x07,te290[x-1]);
                sendSPI(0x08,te190[x-1]); 
                break; 
         case 3:
            for(j=0;j<=7;j++)
             {
                sendSPI(0x0+j,te1180[x-1]);
                sendSPI(0x0+(j+1),te2180[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                sendSPI(0x0+(j+2),0x00);
                wait_us(10); 
            } 
                sendSPI(0x07,te1180[x-1]);
                sendSPI(0x08,te2180[x-1]); 
                break; 
         case 4:
            for(j=0;j<=6;j++)
             {
                sendSPI(0x0+j,te1270[x-1]);
                sendSPI(0x0+(j+1),te2270[x-1]);
                sendSPI(0x0+(j+2),te1270[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                sendSPI(0x0+(j+2),0x00);
                wait_us(10); 
            } 
                sendSPI(0x06,te1270[x-1]);
                sendSPI(0x07,te2270[x-1]);
                sendSPI(0x08,te1270[x-1]); 
                break; 
        }                
};

void ese(int x,int y)
{
    int ese10[8]={0x60,0x30,0x18,0xc,0x6,0x3,0x1,0x0};
    int ese20[8]={0xc0,0x60,0x30,0x18,0xc,0x6,0x3,0x01};
    int ese190[8]={0b10000000,0b01000000,0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0x01};
    int ese290[8]={0b11000000,0b01100000,0b00110000,0b00011000,0b00001100,0b00000110,0b00000011,0x01};
    int ese390[8]={0b01000000,0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0b00000001,0x00};
    
    int j;
    switch(y)
    {
         case 1: case1:
                for(j=0;j<=6;j++)
                {
                sendSPI(0x0+j,ese10[x-1]);
                sendSPI(0x0+(j+1),ese20[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                wait_us(10); 
                } 
                sendSPI(0x07,ese10[x-1]);
                sendSPI(0x08,ese20[x-1]);
                break;  
         case 2: case2:
                for(j=0;j<=6;j++)
                {
                sendSPI(0x0+j,ese190[x-1]);
                sendSPI(0x0+(j+1),ese290[x-1]);
                sendSPI(0x0+(j+2),ese390[x-1]);
                wait_ms(200);
                sendSPI(0x0+j,0x00);
                sendSPI(0x0+(j+1),0x00);
                wait_us(10); 
                } 
                sendSPI(0x06,ese190[x-1]);
                sendSPI(0x07,ese290[x-1]);
                sendSPI(0x08,ese390[x-1]);
                break; 
        case 3: goto case1;
        case 4: goto case2;
    }                
};

void borrar()
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(0x0+i,0x00);
    }
};

void dibujar(int type_fig,int grados, int columna)
{
    //borrar();
    
    switch (type_fig){
        case FIG_C: cuadro(columna,grados); break;
        case FIG_I: linea(columna,grados);  break;
        case FIG_L: ele(columna,grados); break;
        case FIG_T: te(columna,grados); break;
        case FIG_S: ese(columna,grados); break;
    
    };
    
}

int main() {
    sendSPI(0x09,0);        //no decodificacion
    sendSPI(0x0A,0x0);     //intensidad
    sendSPI(0x0B,0x07);     //usa 7 leds                     
    sendSPI(0x0C,1);        //no apaga
    sendSPI(0x0F,0);        //operacion normal  
 
    int tipo_fig=1,ncolumna=1,grados=1,lee1=0x00,lee2=0x00;  // enviar ficha y columna
    
    while(1){
        lee1=command.getc();
        tipo_fig=command.getc();
        grados=command.getc();
        ncolumna=command.getc();       
        lee2=command.getc();
        
            if(lee1==0x3c && lee2==0x3e)
            {
            dibujar(tipo_fig,grados,ncolumna);           
            }        
        }
    }