/**
 * @file TA8428.h
 * @brief This library is for controlling TA8428 (full-bridge driver (mainly for motor drive.)
 * @author Yuki Suga
 * @mail ysuga@ysuga.net
 * @affilication Ogata Laboratory, Waseda University
 * @url http://ogata-lab.jp/
 * @copyright 2013, Ogata Laboratory
 * @license public domain
 */
#ifndef TA8428_HEADER_INCLUDED
#define TA8428_HEADER_INCLUDED

class TA8428 {
private:
  PwmOut p0;
  PwmOut p1;
  
  float period;


public:
public:
  /**
   * @brief Constructor
   *
   * @param pin0 PWM pin, in mbed p21 - 26
   * @param pin1 PWM pin, in mbed p21 - 26
   */
  TA8428(PinName pin0, PinName pin1, const float period=0.020);
  
  ~TA8428();
  
  /**
   * @param pwmPercent [-1.0, 1.0]
   */
  void drive(const float pwmPercent);

};

#endif