/**
 * @file TA8428.cpp
 * @brief This library is for controlling TA8428 (full-bridge driver (mainly for motor drive.)
 * @author Yuki Suga
 * @mail ysuga@ysuga.net
 * @affilication Ogata Laboratory, Waseda University
 * @url http://ogata-lab.jp/
 * @copyright 2013, Ogata Laboratory
 * @license public domain
 */
 
#include "mbed.h"
#include "TA8428.h"


TA8428::TA8428(PinName pin0, PinName pin1, const float period) :
p0(pin0), p1(pin1) 
{
  p0.period(period);
  p1.period(period);
}

TA8428::~TA8428()
{

}

void TA8428::drive(const float pwmPercent)
{
  if (pwmPercent < 0) {
    p0.write(0.0);
    p1.write(-pwmPercent);
  } else {
    p0.write(pwmPercent);
    p1.write(0.0);
  }
}
