#ifndef HSV_TO_RGB_HEADER_INCLUDED
#define HSV_TO_RGB_HEADER_INCLUDED


#include <math.h>

/**
 * HSV
 * H [0, 360.0f]
 * S [0, 255.0f]
 * V [0, 255.0f]
 */
struct HSV {
  float h;
  float s;
  float v;
};

/**
 * RGB
 * R,G,B [0, 255.0f]
 */
struct RGB {
  float r;
  float g;
  float b;
};

float round(float v) {
   float vc = ceil(v);
   if (v-vc >= 0.5) return vc+1;
   return vc;
}

RGB HSV2RGB(HSV& hsv) {
  float f;
  int i, p, q, t;
  RGB rgb;
        
  i = (int)floor(hsv.h / 60.0f) % 6;
        f = (float)(hsv.h / 60.0f) - (float)floor(hsv.h / 60.0f);
        p = (int)round(hsv.v * (1.0f - (hsv.s / 255.0f)));
        q = (int)round(hsv.v * (1.0f - (hsv.s / 255.0f) * f));
        t = (int)round(hsv.v * (1.0f - (hsv.s / 255.0f) * (1.0f - f)));
        
        switch(i){
            case 0 : rgb.r = hsv.v; rgb.g = t; rgb.b = p; break;
            case 1 : rgb.r = q; rgb.g = hsv.v; rgb.b = p; break;
            case 2 : rgb.r = p; rgb.g = hsv.v; rgb.b = t; break;
            case 3 : rgb.r = p; rgb.g = q; rgb.b = hsv.v; break;
            case 4 : rgb.r = t; rgb.g = p; rgb.b = hsv.v; break;
            case 5 : rgb.r = hsv.v; rgb.g = p; rgb.b = q; break;
        }

        return rgb;
}

#endif