#include "mbed.h"
#include "Serial.h"

AnalogIn ain0(p17);
AnalogIn ain1(p18);
AnalogIn ain2(p19);
AnalogIn ain3(p20);

DigitalIn sw01(p21);
Serial usbSerial(USBTX, USBRX);

DigitalOut leds[4] = {LED1, LED2, LED3, LED4};

#define REQUEST_ANALOG 'R'
#define LED_ON  'Y'
#define LED_OFF 'N'
#define UNKNOWN 'U'

int main() {

    sw01.mode(PullUp);
    int i = 0;
    int response = 0;
    int command = 0;
    int argument = 0;
    float analog0, analog1, analog2, analog3;
    while(1) {
        usbSerial.scanf("%c, %d", &command, &argument);
        switch(command) {
        case REQUEST_ANALOG:
            response = REQUEST_ANALOG;
            analog0 = ain0;
            analog1 = ain1;
            analog2 = ain2;
            analog3 = ain3;
            usbSerial.printf("%c, %f, %f, %f, %f\r\n", response, analog0, analog1, analog2, analog3);
            break;
        case LED_ON:
            leds[argument] = 1;
            response = LED_ON;
            usbSerial.printf("%c, 0\r\n", response);
            break;
        case LED_OFF:
            leds[argument] = 0;
            response = LED_OFF;
            usbSerial.printf("%c, 0\r\n", response);
            break;
        default:
            response = UNKNOWN;
            usbSerial.printf("%c, 1\r\n", response);
            break;
        }
        int sw = sw01;
    }
}