#include "mbed.h"
#include "HSVtoRGB.h"

PwmOut r(p21), g(p22), b(p23);

int main() {
    r.period(0.02);
    g.period(0.02);
    b.period(0.02);
    while(1) {

        for(int i = 0;i < 100;i++) {
           HSV hsv;
           hsv.h = 3.6f*i;
           hsv.s = 255;
           hsv.v = 255;
           RGB rgb = HSV2RGB(hsv);
           r.write(1.0f-rgb.r/255.0f);
           g.write(1.0f-rgb.g/255.0f);
           b.write(1.0f-rgb.b/255.0f);
           wait(0.1);
        }

    }
}
