#include "mbed.h"
#include "Switch.h"

Switch::Switch( PinName sw0, PinName sw1)
    : _sw0(sw0), _sw1(sw1)
{
}

void Switch::begin(void)
{
    _sw0.mode(PullUp);
    _sw1.mode(PullUp);
    _swchecker.attach_us(this, &Switch::swcheck, 4000);
}

void Switch::swcheck(void)
{
    sw[0] = _sw0.read();
    sw[1] = _sw1.read();
    for (uint8_t i = 0; i < 2; i++) {
        buffer[i] = (buffer[i] << 1) | (0x01 & sw[i]);
        if (buffer[i] == 0x00) {
            swst[i] |= 0x01;
            if ((prev[i] &0x01) != (swst[i] & 0x01)) swst[i] |= 0x10;
        } else {
            swst[i] &= 0xfe;
        }
        if (buffer[i] == 0xff) {
            swst[i] |= 0x02;
            if ((prev[i] &0x02) != (swst[i] & 0x02)) swst[i] |= 0x20;
        } else {
            swst[i] &= 0xfd;
        }
        prev[i] = swst[i];
    }
}

uint8_t Switch::negedge(uint8_t no)
{
    uint8_t st = 0;
    if (swst[no] & 0x10)
        st = 1;
    return (st);
}

uint8_t Switch::posedge(uint8_t no)
{
    uint8_t st = 0;
    if (swst[no] & 0x20)
        st = 1;
    return (st);
}

void Switch::clear(uint8_t no)
{
    swst[no] &= 0x0f;
}

uint8_t Switch::level(uint8_t no)
{
    uint8_t l;
    uint8_t st = swst[no] & 0x0f;
    if (st == 0x01)
        l = 0;
    else if (st == 0x02)
        l = 1;
    else
        l = 0xff;
    return (l);
}
