#ifndef MBED_SWITCH_H
#define MBED_SWITCH_H

#include "mbed.h"

class Switch
{
private:
    DigitalIn _sw0;
    DigitalIn _sw1;
    Ticker _swchecker;

    uint8_t buffer[2];
    uint8_t swst[2];
    uint8_t sw[2];
    uint8_t prev[2];

public:
    Switch( PinName sw0, PinName sw1);
    ~Switch(){};
    void begin(void);
    void swcheck(void);
    uint8_t negedge(uint8_t no);
    uint8_t posedge(uint8_t no);
    void clear(uint8_t no);
    uint8_t level(uint8_t no);
};

#endif  //MBED_SWITCH_H
