#include "mbed.h"
#include "NJU6063.h"
#include "Switch.h"
/**
* STM32 I2C dont'work after Nack.
*/
//#ifdef TARGET_ARCH_PRO
#ifdef TARGET_ARCH_PRO
Serial pc(USBTX, USBRX);
NJU6063 nju6063(p28, p27, P0_4);   // sda scl rst
Switch sw(P2_0, P2_1);   // 
#elif defined TARGET_LPC1768
// mbed LPC1114FN28
Serial pc(USBTX, USBRX);
NJU6063 nju6063(p9, p10, p7);   // sda scl rst
Switch sw(p15,p16);   // 
#elif defined TARGET_LPC1114
// mbed LPC1114FN28
//Serial pc(dp16, dp15);
NJU6063 nju6063(dp5, dp27, dp18);   // sda scl rst
Switch sw(dp17,dp14);   // 
#elif defined TARGET_LPC11U35_501
//Serial pc(p19, p18);
NJU6063 nju6063(p28, p27, p25);   // sda scl rst
Switch sw(p11,p12);   // 
#elif defined TARGET_NUCLEO_F401RE
NJU6063 nju6063(I2C_SDA, I2C_SCL, PA_10);   // sda scl rst
Switch sw(PA_0, PA_1);   // 
Serial pc(SERIAL_TX, SERIAL_RX);
//#elif defined TARGET_NUCLEO_F042K6
//NJU6063 nju6063(PB_7, PB_6, PB_1);   // sda scl rst
//Switch sw(PA_0, PA_1);   // 
//Serial pc(SERIAL_TX, SERIAL_RX);
#endif

#define MAXCHIP 8
#define DIMPATMAX 4
#define MAXPAT 24

const uint8_t PAT[DIMPATMAX][MAXPAT][4] = {
    {
    {0xff, 0x00, 0xff, 0x5f},
    {0xbf, 0x00, 0xff, 0x5f},
    {0x7f, 0x00, 0xff, 0x5f},
    {0x3f, 0x00, 0xff, 0x5f},
    {0x00, 0x00, 0xff, 0x5f},
    {0x00, 0x3f, 0xff, 0x5f},
    {0x00, 0x7f, 0xff, 0x5f},
    {0x00, 0xbf, 0xff, 0x5f},
    {0x00, 0xff, 0xff, 0x5f},
    {0x00, 0xff, 0xbf, 0x5f},
    {0x00, 0xff, 0x7f, 0x5f},
    {0x00, 0xff, 0x3f, 0x5f},
    {0x00, 0xff, 0x00, 0x5f},
    {0x3f, 0xff, 0x00, 0x5f},
    {0x7f, 0xff, 0x00, 0x5f},
    {0xbf, 0xff, 0x00, 0x5f},
    {0xff, 0xff, 0x00, 0x5f},
    {0xff, 0xbf, 0x00, 0x5f},
    {0xff, 0x7f, 0x00, 0x5f},
    {0xff, 0x3f, 0x00, 0x5f},
    {0xff, 0x00, 0x00, 0x5f},
    {0xff, 0x00, 0x3f, 0x5f},
    {0xff, 0x00, 0x7f, 0x5f},
    {0xff, 0x00, 0xbf, 0x5f}
    },
    {
    {0xff, 0x00, 0xff, 0x50},
    {0xbf, 0x00, 0xff, 0x50},
    {0x7f, 0x00, 0xff, 0x50},
    {0x3f, 0x00, 0xff, 0x50},
    {0x00, 0x00, 0xff, 0x50},
    {0x00, 0x3f, 0xff, 0x50},
    {0x00, 0x7f, 0xff, 0x50},
    {0x00, 0xbf, 0xff, 0x50},
    {0x00, 0xff, 0xff, 0x50},
    {0x00, 0xff, 0xbf, 0x50},
    {0x00, 0xff, 0x7f, 0x50},
    {0x00, 0xff, 0x3f, 0x50},
    {0x00, 0xff, 0x00, 0x50},
    {0x3f, 0xff, 0x00, 0x50},
    {0x7f, 0xff, 0x00, 0x50},
    {0xbf, 0xff, 0x00, 0x50},
    {0xff, 0xff, 0x00, 0x50},
    {0xff, 0xbf, 0x00, 0x50},
    {0xff, 0x7f, 0x00, 0x50},
    {0xff, 0x3f, 0x00, 0x50},
    {0xff, 0x00, 0x00, 0x50},
    {0xff, 0x00, 0x3f, 0x50},
    {0xff, 0x00, 0x7f, 0x50},
    {0xff, 0x00, 0xbf, 0x50}
    },
    {
    {0xff, 0x00, 0x00, 0x00},
    {0x00, 0xff, 0x00, 0x00},
    {0x00, 0x00, 0xff, 0x00},
    {0xff, 0x00, 0x00, 0x00},
    {0x00, 0xff, 0x00, 0x00},
    {0x00, 0x00, 0xff, 0x00},
    {0xff, 0x00, 0x00, 0x00},
    {0x00, 0xff, 0x00, 0x00},
    {0x00, 0x00, 0xff, 0x00},
    {0xff, 0x00, 0x00, 0x00},
    {0x00, 0xff, 0x00, 0x00},
    {0x00, 0x00, 0xff, 0x00},
    {0xff, 0x00, 0x00, 0x00},
    {0x00, 0xff, 0x00, 0x00},
    {0x00, 0x00, 0xff, 0x00},
    {0xff, 0x00, 0x00, 0x00},
    {0x00, 0xff, 0x00, 0x00},
    {0x00, 0x00, 0xff, 0x00},
    {0xff, 0x00, 0x00, 0x00},
    {0x00, 0xff, 0x00, 0x00},
    {0x00, 0x00, 0xff, 0x00},
    {0xff, 0x00, 0x00, 0x00},
    {0x00, 0xff, 0x00, 0x00},
    {0x00, 0x00, 0xff, 0x00}
    },
    {
    {0xff, 0x00, 0x00, 0x0f},
    {0x00, 0xff, 0x00, 0x0f},
    {0x00, 0x00, 0xff, 0x0f},
    {0xff, 0x00, 0x00, 0x0f},
    {0x00, 0xff, 0x00, 0x0f},
    {0x00, 0x00, 0xff, 0x0f},
    {0xff, 0x00, 0x00, 0x0f},
    {0x00, 0xff, 0x00, 0x0f},
    {0x00, 0x00, 0xff, 0x0f},
    {0xff, 0x00, 0x00, 0x0f},
    {0x00, 0xff, 0x00, 0x0f},
    {0x00, 0x00, 0xff, 0x0f},
    {0xff, 0x00, 0x00, 0x0f},
    {0x00, 0xff, 0x00, 0x0f},
    {0x00, 0x00, 0xff, 0x0f},
    {0xff, 0x00, 0x00, 0x0f},
    {0x00, 0xff, 0x00, 0x0f},
    {0x00, 0x00, 0xff, 0x0f},
    {0xff, 0x00, 0x00, 0x0f},
    {0x00, 0xff, 0x00, 0x0f},
    {0x00, 0x00, 0xff, 0x0f},
    {0xff, 0x00, 0x00, 0x0f},
    {0x00, 0xff, 0x00, 0x0f},
    {0x00, 0x00, 0xff, 0x0f}
    }
};
#define MAXPAT1 6
const uint8_t PAT1[2][MAXPAT1][3] = {
    //  G     R     B
   {{0x00, 0xff, 0xff},
    {0x00, 0x00, 0xff},
    {0xff, 0x00, 0xff},
    {0xff, 0x00, 0x00},
    {0xff, 0xff, 0x00},
    {0x00, 0xff, 0x00}},
   {{0xff, 0x00, 0x00},
    {0x00, 0xff, 0x00},
    {0x00, 0x00, 0xff},
    {0xff, 0x00, 0x00},
    {0x00, 0xff, 0x00},
    {0x00, 0x00, 0xff}}
};

int i;
int mode;
uint8_t step_color1;
uint8_t dim_pat_no;
uint8_t max_chip;

void color0(uint8_t no, uint8_t loop){
    uint8_t step_color0;
    uint8_t n;
    uint8_t pat_no;
    pat_no = no % DIMPATMAX;
    nju6063.check_dim();
    for (n = 0; n < max_chip; n++) {
        step_color0 = i + n;
        if (step_color0 >= MAXPAT) {
            step_color0 = step_color0 - MAXPAT;
        }
        nju6063.set_pwm(
                n+1,
                PAT[pat_no][step_color0][0],
                PAT[pat_no][step_color0][1],
                PAT[pat_no][step_color0][2],
                PAT[pat_no][step_color0][3]
                );
    }
    nju6063.dim_start(NJU6063_ALL);
    i++;
    if (i >= MAXPAT) {
        i = 0;
    }
}
void color1(){
    nju6063.check_dim();
    nju6063.set_pwm(
            0xff,
            PAT1[0][step_color1][0],
            PAT1[0][step_color1][1],
            PAT1[0][step_color1][2],
            0x00
            );
    nju6063.dim_start(NJU6063_ALL);
    step_color1++;
    if (step_color1 >= MAXPAT1) {
        step_color1 = 0;
    }
}
void color2(uint8_t pat_no, uint8_t loop){
    int n;
    nju6063.check_dim();
    for (n = 0; n < max_chip; n++) {
        step_color1 = i + n;
        if (step_color1>= MAXPAT1) {
            step_color1 = step_color1 - MAXPAT1;
        }
        nju6063.set_pwm(
                n+1,
                PAT1[pat_no][step_color1][0],
                PAT1[pat_no][step_color1][1],
                PAT1[pat_no][step_color1][2],
                loop
                );
    }
    nju6063.dim_start(NJU6063_ALL);
    i++;
    if (i >= MAXPAT1) {
        i = 0;
    }
}

/*
SW2 SW1
  H   v     dim start
  L   v     dimpat inc
  v   H     pat inc
  v   L     pat group
*/


int main () {
    pc.printf("NJU6063\r\n");
    sw.begin();
    dim_pat_no = 0;
    mode = 1;
    i = 0;
    nju6063.reset();
    max_chip=nju6063.set_multi_device(0x08);
    pc.printf("N %d\r\n", max_chip);
    //chip = MAXCHIP;
    nju6063.init(NJU6063_ALL, NJU6063_EN);
    //nju6063.set_iled(NJU6063_ALL, NJU6063_ILED1X1, NJU6063_ILED2X1, NJU6063_ILED3X1);
    nju6063.set_iled(NJU6063_ALL, NJU6063_ILED1X025, NJU6063_ILED2X025, NJU6063_ILED3X025);
    nju6063.set_pwm(NJU6063_ALL, 0x7f,0x7f,0x7f);
    nju6063.dim_start(NJU6063_ALL);
    sw.clear(0);
    sw.clear(1);
    //while(1){};
    while(1){
        //printf("X %d\r\n", mode);
        if(sw.negedge(0)){
            if (sw.level(1)) {
                mode = 1;
                dim_pat_no++;
                //printf("A %d\r\n", mode);
            }else{
                mode++;
                //printf("B %d\r\n", mode);
            }
            sw.clear(0);
        }
        if(sw.negedge(1)){
            if (sw.level(0)) {
                switch (mode){
                    case 2: color1(); break;
                    case 3: color2(0, 0x00); break;
                    case 4: color2(0, 0x5f); break;
                    case 5: color2(1, 0x00); break;
                    case 6: color2(1, 0x5f); break;
                    default: mode = 2; color1();
                }
                //printf("C %d\r\n", mode);
            }else{
                mode--;
                //printf("D %d\r\n", mode);
            }
            sw.clear(1);
        }
        if (mode == 1) {
            color0(dim_pat_no, 0x5f);
            //wait(0.1);
        }
    }
}

