#include "NJU6063.h"
//#ifndef TARGET_STM 
NJU6063::NJU6063( PinName sda, PinName scl, PinName rst)
    : _i2c(sda, scl), _rst(rst)
{
    //_i2c.frequency(400000);
}

void NJU6063::reset(void)
{
    NJU6063_WAIT_MS;
    _rst = 0;
    NJU6063_WAIT_MS;
    _rst = 1;
}

uint8_t NJU6063::set_multi_device(uint8_t n)
{
    //_myI2c = (I2C_TypeDef*)I2C_1;
    //IS_I2C_NO_STRETCH(I2C_NOSTRETCH_ENABLE);
    uint8_t ret;
    char data[3];
    ret = n;
    data[0] = 0x00;             // Initial chip addres
    data[1] = NJU6063_MADRES;    // multi device address
#ifdef TARGET_NUCLEO_F042K6
    for (uint8_t i=1; i<=n; i++) {
        data[2] = i;
        ack= _i2c.write(NJU6063_SLAVE, data, 2);
        NJU6063_WAIT;
        if (ack) {
            ret = i-1;
            break;
        }
        else {
            ack= _i2c.write(NJU6063_SLAVE, data, 3);
        }
    }
#else
    for (uint8_t i=1; i<=n; i++) {
        data[2] = i;
        ack= _i2c.write(NJU6063_SLAVE, data, 3);
        NJU6063_WAIT;
        if (ack) {
            ret = i-1;
            break;
        }
    }
#endif
    return(ret);
}
void NJU6063::init(uint8_t chip_addr, uint8_t d)
{
    char data[3];
    data[0] = chip_addr;
    data[1] = NJU6063_INIT;
    data[2] = d;
    ack = _i2c.write(NJU6063_SLAVE, data, 3);
    NJU6063_WAIT;
}

void NJU6063::set_iled(uint8_t chip_addr, uint8_t d1, uint8_t d2, uint8_t d3)
{
    char data[3];
    data[0] = chip_addr;
    data[1] = NJU6063_ILED;
    data[2] = (0x03&d1) | (0x03&d2)<<2 | (0x03&d3) <<4;
    ack = _i2c.write(NJU6063_SLAVE, data, 3);
    NJU6063_WAIT;
}

void NJU6063::set_pwm(uint8_t chip_addr, uint8_t d1, uint8_t d2, uint8_t d3, uint8_t loop, uint8_t son)
{
    char data[7];
    data[0] = chip_addr;
    data[1] = NJU6063_PWM1;
    data[2] = d1;
    data[3] = d2;
    data[4] = d3;
    data[5] = loop;
    data[6] = son;
    ack = _i2c.write(NJU6063_SLAVE, data, 7);
    NJU6063_WAIT;
}
void NJU6063::dim_start(uint8_t chip_addr)
{
    char data[3];
    data[0] = chip_addr;
    data[1] = NJU6063_START; // reg addres
    data[2] = 0x01; // start
    ack = _i2c.write(NJU6063_SLAVE, data, 3);
    NJU6063_WAIT;
}

void NJU6063::dim_stop(uint8_t chip_addr)
{
    char data[3];
    data[0] = chip_addr;
    data[1] = NJU6063_START; // reg addres
    data[2] = 0x02; // stop
    ack = _i2c.write(NJU6063_SLAVE, data, 3);
    NJU6063_WAIT;
}

void NJU6063::check_dim(void)
{
    uint8_t timeout = 0x0f;
    char data[3];
    data[0] = 0xff;
    data[1] = NJU6063_DCHK;
    data[2] = 0x00;
    do {
        ack = _i2c.write(NJU6063_SLAVE, data, 3, true);
        NJU6063_WAIT;
        timeout--;
        if (timeout==0) break;
    } while(!ack);
    NJU6063_WAIT_MS;
}
//#endif

