#include "LCD192GC00.h"
#include "ASCII12dot.h"     //ASCII 12x12dot

LCD192GC00::LCD192GC00(
    PinName rd, PinName wr, PinName rs, PinName cs, PinName rst,
    PinName d0, PinName d1, PinName d2, PinName d3,
    PinName d4, PinName d5, PinName d6, PinName d7
    ):
    _rd(rd), _wr(wr), _rs(rs), _cs(cs), _rst(rst),
    _d(d0, d1, d2, d3, d4, d5, d6, d7)
{
    
    _rd=1; 
    _wr=1;
    _rs=1;
    _cs=1;
    _rst = 1;

}

void LCD192GC00::_write(uint8_t rs, uint8_t d){
    _cs=0;
    _rd=1;
    _rs=rs;

    _d.output();
    _d=d;
    _wr=0;
    //_delay(1);
    _wr=1;

    _cs=1; 
}

void LCD192GC00::lcd_Init(){
    wait_ms(20);
    _rd = 1;
    _cs = 1;             // CS High
    _wr = 1;             // WR High
    _rst = 0;          // Reset LCD
    wait_ms(0x10);             // 1msec wait
    _rst = 1;          // Clear RESET
    wait_ms(25);               // 100msec wait

    lcd_cmd(0xB0);
    lcd_data(0xCA);
    lcd_data(0x90);
    lcd_data(0x37);
    lcd_data(0x01);
    lcd_data(0x48);
    lcd_data(0x01);
    lcd_data(0x40);
    lcd_data(0x04);
    lcd_data(0x00);
    lcd_data(0x00);
    
    lcd_cmd(0x26);
    lcd_data(0x01);
    
    lcd_cmd(0xB1);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x08);
    lcd_data(0x00);
    lcd_data(0x04);
    lcd_data(0x10);
    lcd_data(0x48);
    lcd_data(0x82);
    lcd_data(0x20);
    lcd_data(0x84);
    lcd_data(0x92);
    lcd_data(0x2A);
    lcd_data(0x52);
    lcd_data(0xAA);
    lcd_data(0x5A);
    lcd_data(0x55);
    lcd_data(0x2A);
    lcd_data(0x55);
    lcd_data(0xAE);
    lcd_data(0xFF);
    lcd_data(0xFE);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);
    
    lcd_cmd(0xB2);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);
    lcd_data(0x00);
    lcd_data(0x02);
    lcd_data(0x08);
    lcd_data(0x48);
    lcd_data(0x82);
    lcd_data(0x20);
    lcd_data(0x84);
    lcd_data(0x42);
    lcd_data(0x48);
    lcd_data(0x92);
    lcd_data(0x2A);
    lcd_data(0x52);
    lcd_data(0xAA);
    lcd_data(0x5A);
    lcd_data(0x55);
    lcd_data(0x2A);
    lcd_data(0x55);
    lcd_data(0xAE);
    lcd_data(0xFF);
    lcd_data(0xFE);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);
    
    lcd_cmd(MODE);          // Entry Mode
    lcd_data(0x29);
    //color mode
    lcd_cmd(COLMOD);
    lcd_data(0x05);         //65k color
    //Inteface mode
    lcd_cmd(IFMOD);
    lcd_data(0x00);         //8bit mode
    
    
    lcd_cmd(0xBA);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55); 
    lcd_data(0x55);
    
    
    //
    lcd_cmd(SLPOUT);
    lcd_cmd(DISON);         // 表示オン
};

void LCD192GC00::lcd_Clear(unsigned short Color){
    int i, j;

    lcd_cmd(PASET);         // ページ開始終了アドレスセット
    lcd_data(0);
    lcd_data(0x0C);
    lcd_data((unsigned char)((ENDPAGE+0x0C)>>8));
    lcd_data((unsigned char)(ENDPAGE+0x0C));
    lcd_cmd(CASET);         // コラム開始、終了アドレスセット
    lcd_data(0);
    lcd_data(0x08);
    lcd_data((unsigned char)((ENDCOL+0x08)>>8)); 
    lcd_data((unsigned char)(ENDCOL+0x08));
    lcd_cmd(RAMWR);
    for(j=0; j<4; j++){
        for(i=0; i<(ENDCOL+1)*80; i++){
            lcd_data((unsigned char)(Color>>8));
            lcd_data((unsigned char)Color);
        }
    }   
}

/***********************************
*  １ピクセル表示関数
*  座標は(0,0)-(161,131)  
***********************************/
void LCD192GC00::lcd_Pixel(short Xpos, short Ypos, unsigned short Color){

    if((Xpos<=ENDCOL) && (Ypos<=ENDPAGE)){
        Xpos += 0x08;
        Ypos += 0x0C;
        lcd_cmd(PASET);             // 行（RAW)アドレスセット
        lcd_data(Ypos>>8);
        lcd_data(Ypos);
        lcd_data(Ypos>>8);
        lcd_data(Ypos);
        lcd_cmd(CASET);             // 列（COLUM)アドレスセット
        lcd_data((unsigned char)((Xpos)>>8));
        lcd_data((unsigned char)(Xpos));
        lcd_data((unsigned char)(Xpos>>8));
        lcd_data((unsigned char)(Xpos));
        lcd_cmd(RAMWR);             // 1ピクセル書き込み
        lcd_data(Color >> 8);           // 16ビットカラー
        lcd_data(Color);
    }
}

/***************************
*  直線描画関数
***************************/
#define abs(a)  (((a)>0) ? (a) : -(a))
void LCD192GC00::lcd_Line(short x0, short y0, short x1, short y1, unsigned short Color)
{
    short steep, t;
    short deltax, deltay, error;
    short x, y;
    short ystep;
    
    y0=ENDPAGE-y0;                      // Y座標反転
    y1=ENDPAGE-y1;
    /// 差分の大きいほうを求める
    steep = (abs(y1 - y0) > abs(x1 - x0));
    /// ｘ、ｙの入れ替え
    if(steep){
        t = x0; x0 = y0; y0 = t;
        t = x1; x1 = y1; y1 = t;
    }
    if(x0 > x1) {
        t = x0; x0 = x1; x1 = t;
        t = y0; y0 = y1; y1 = t;
    }
    deltax = x1 - x0;                       // 傾き計算 
    deltay = abs(y1 - y0);
    error = 0;
    y = y0;
    /// 傾きでステップの正負を切り替え
    if(y0 < y1) ystep = 1; else ystep = -1;
    /// 直線を点で描画
    for(x=x0; x<x1; x++) {
        if(steep) lcd_Pixel(y,x,Color); else lcd_Pixel(x,y,Color);
        error += deltay;
        if((error << 1) >= deltax) {
            y += ystep;
            error -= deltax;
        }
    }
}
/*****************************************
*  ANK文字表示関数 12x12ドット
*  320/12=26文字/行　240/14=17行
*  (0, 0) - (25, 16)の範囲
******************************************/
void LCD192GC00::lcd_Char(char colum, char line, unsigned char letter, unsigned short Color1, unsigned short Color2){
    unsigned char j, i, Mask;

    if((colum < XChar) && (line < YLine)){      // 範囲チェック
        // ANK表示出力　3バイトの2ラインずつを6回繰り返す
        for(j=0; j<6; j++){
            // 8ドット連続部の表示
            Mask = 0x80;
            for(i=0; i<8; i++){
                // １ライン目前半8ドット表示
                if((ANKFont[letter][j*3] & Mask) != 0)
                    lcd_Pixel(colum*12+i, line*14+j*2, Color1);
                else
                    lcd_Pixel(colum*12+i, line*14+j*2, Color2);     //背景色
                // 2ライン目後半8ドット表示
                if((ANKFont[letter][j*3+2] & Mask) != 0)
                    lcd_Pixel(colum*12+i+4, line*14+j*2+1, Color1);
                else
                    lcd_Pixel(colum*12+i+4, line*14+j*2+1, Color2);     //背景色
                Mask = Mask >> 1;
            }
            // 分割部4ドットずつ表示
            Mask = 0x80;
            // 1ライン目後半4ドット表示
            for(i=0; i<4; i++){
                if((ANKFont[letter][j*3+1] & Mask) != 0)
                    lcd_Pixel(colum*12+i+8, line*14+j*2, Color1);
                else
                    lcd_Pixel(colum*12+i+8, line*14+j*2, Color2);    //背景色
                Mask = Mask >> 1;
            }
            // 2ライン目前半4ドット表示
            for(i=4; i<8; i++){
                if((ANKFont[letter][j*3+1] & Mask) != 0)
                    lcd_Pixel(colum*12+i-4, line*14+j*2+1, Color1);
                else
                    lcd_Pixel(colum*12+i-4, line*14+j*2+1, Color2);     //背景色
                Mask = Mask >> 1;
            }                           
        }
    }
}
/******************************
*   文字列描画関数
*   16文字ｘ20行で指定
******************************/
void LCD192GC00::lcd_Str(char colum, char line, char *s, unsigned short Color1, unsigned short Color2)
{
        while (*s){
        lcd_Char(colum++, line, *s++, Color1, Color2);
        if(colum >= XChar){
            line++;
            colum = 0;
            if(line >= YLine)
                line = 0;
        }
    }
}

/*********************************************************
* イメージ表示関数
*　 データは縦方向8ライン分が1バイトで格納されている
*   128×128/8=2kバイト/画面
*   グラフィック色(Color1)と背景色(Color2)両方を指定
**********************************************************/
void LCD192GC00::lcd_Image(char line, const unsigned char *ptr, unsigned short Color1, unsigned Color2)
{
    unsigned char Mask;
    short i, vline, colum;


    for(vline=line; vline<line+8; vline++){             // 全体は8行×8=64ライン
        for(colum=0; colum<128; colum++){       // 横は128ドットとする
            Mask = 0x01;                        // 下位ビットが上側
            for(i=0; i<8; i++){             // 1バイト分処理
                if(*ptr & Mask)             // ビットチェック
                    lcd_Pixel(colum+2, vline*8+i+1, Color1);
                else
                    lcd_Pixel(colum+2,vline*8+i+1,  Color2);                    
                Mask = Mask << 1;               // ビット位置シフト
            } 
            ptr++;                          // 次のデータ
        }
    }
}

void LCD192GC00::_delay(uint16_t t)
{
};
