#ifndef MBED_LCD192GC00_H
#define MBED_LCD192GC00_H
#include "mbed.h"

#define MODE    0x36
#define CASET   0x2A
#define PASET   0x2B
#define COLMOD  0x3A
#define IFMOD   0xC2
#define RAMWR   0x2C
#define SLPOUT  0x11
#define DISON   0x29

#define ENDCOL  319 // X
#define ENDPAGE 239 // Y
#define XChar   (int16_t)((ENDCOL+1) / 12)
#define YLine   (int16_t)((ENDPAGE+1) / 14)

#define WHITE       0xFFFF
#define BLACK       0x0000
#define RED         0xF800
#define GREEN       0x07E0
#define BLUE        0x001F
#define CYAN        0x07FF
#define MAGENTA     0xF81F
#define YELLOW      0xFFE0
#define BROWN       0xA18A
#define ORANGE      0xFBC0
#define PINK        0xF998

class LCD192GC00
{
public:
    LCD192GC00(
    PinName rd, PinName wr, PinName rs, PinName cs, PinName rst,
    PinName d0, PinName d1, PinName d2, PinName d3,
    PinName d4, PinName d5, PinName d6, PinName d7
    );
    ~LCD192GC00(){};

    /***  関数プロトタイプ ****/
    void lcd_Init(void);
    void lcd_Clear(unsigned short Color);
    void lcd_Pixel(short Xpos, short Ypos, unsigned short Color);
    void lcd_Char(char colum, char line, unsigned char letter, unsigned short Color1, unsigned short Color2);
    void lcd_Str(char colum, char line, char *s, unsigned short Color1, unsigned short Color2);
    void lcd_Line(short x0, short y0, short x1, short y1, unsigned short Color);
    void lcd_Scroll(unsigned short delay);
    void lcd_Image(char line, const unsigned char *ptr, unsigned short Color1, unsigned Color2);

    void lcd_cmd(uint8_t data){
        _write(0, data);
    };
    void lcd_data(uint8_t data){
        _write(1, data);
    };

private:
    DigitalOut _rd, _wr, _rs, _cs, _rst;
    BusInOut  _d;
      
    void _write(uint8_t rs, uint8_t d);
    void _delay(uint16_t t);
};
#endif
