#include "HX8347D.h"
#include "glcdfont.h"

#define X(x) (x)
#define I_X(x) (TFTWIDTH - x - 1)
#define Y(y) (y)
#define I_Y(y) (TFTHEIGHT - y - 1)

size_t HX8347D::println(char *c){
  while (c[0] != 0) {
    write(c[0]);
    c++;
  }
    //drawString(cursor_x, cursor_y, c, textcolor);
    return sizeof(c);
}
/*
size_t TFTLCD::println(unsigned long n , int t){
    //drawString(cursor_x, cursor_y, n, textcolor);
}
*/

HX8347D::HX8347D(
    PinName rd, PinName wr, PinName rs, PinName cs, PinName rst,
    PinName d0, PinName d1, PinName d2, PinName d3,
    PinName d4, PinName d5, PinName d6, PinName d7
    ):
    _rd(rd), _wr(wr), _rs(rs), _cs(cs), _rst(rst),
    _d(d0, d1, d2, d3, d4, d5, d6, d7)
{
    rotation = 0;
    _width = TFTWIDTH;
    _height = TFTHEIGHT;
    
  _rd=1; 
  _wr=1;
  _rs=1;
  _cs=1;
  _rst = 1;

  cursor_y = cursor_x = 0;
  textsize = 1;
  textcolor = 0xFFFF;
 }


void HX8347D::goHome(void) {
  goTo(0,0);
}

uint16_t HX8347D::width(void) {
  return _width;
}
uint16_t HX8347D::height(void) {
  return _height;
}

void HX8347D::setCursor(uint16_t x, uint16_t y) {
  cursor_x = x;
  cursor_y = y;
}

void HX8347D::setTextSize(uint8_t s) {
  textsize = s;
}

void HX8347D::setTextColor(uint16_t c) {
  textcolor = c;
}

size_t HX8347D::write(uint8_t c) {
  if (c == '\n') {
    cursor_y += textsize*8;
    cursor_x = 0;
  } else if (c == '\r') {
    // skip em
  } else {
    drawChar(cursor_x, cursor_y, c, textcolor, textsize);
    cursor_x += textsize*6;
  }
  return 0;
}

void HX8347D::drawString(uint16_t x, uint16_t y, char *c, 
            uint16_t color, uint8_t size) {
  while (c[0] != 0) {
    drawChar(x, y, c[0], color, size);
    x += size*6;
    c++;
  }
}
// draw a character
void HX8347D::drawChar(uint16_t x, uint16_t y, char c, 
              uint16_t color, uint8_t size) {
  for (uint8_t i =0; i<5; i++ ) {
    uint8_t line = font[(c*5)+i];
    for (uint8_t j = 0; j<8; j++) {
      if (line & 0x1) {
    if (size == 1) // default size
      drawPixel(x+i, y+j, color);
    else {  // big size
      fillRect(x+i*size, y+j*size, size, size, color);
    } 
      }
      line >>= 1;
    }
  }
}


void HX8347D::drawTriangle(uint16_t x0, uint16_t y0,
              uint16_t x1, uint16_t y1,
              uint16_t x2, uint16_t y2, uint16_t color)
{
  drawLine(x0, y0, x1, y1, color);
  drawLine(x1, y1, x2, y2, color);
  drawLine(x2, y2, x0, y0, color); 
}

void HX8347D::fillTriangle ( int32_t x0, int32_t y0, int32_t x1, int32_t y1, int32_t x2, int32_t y2, uint16_t color)
{
  if (y0 > y1) {
    swap(y0, y1); swap(x0, x1);
  }
  if (y1 > y2) {
    swap(y2, y1); swap(x2, x1);
  }
  if (y0 > y1) {
    swap(y0, y1); swap(x0, x1);
  }

  int32_t dx1, dx2, dx3; // Interpolation deltas
  int32_t sx1, sx2, sy; // Scanline co-ordinates

  sx2=(int32_t)x0 * (int32_t)1000; // Use fixed point math for x axis values
  sx1 = sx2;
  sy=y0;

  // Calculate interpolation deltas
  if (y1-y0 > 0) dx1=((x1-x0)*1000)/(y1-y0);
    else dx1=0;
  if (y2-y0 > 0) dx2=((x2-x0)*1000)/(y2-y0);
    else dx2=0;
  if (y2-y1 > 0) dx3=((x2-x1)*1000)/(y2-y1);
    else dx3=0;

  // Render scanlines (horizontal lines are the fastest rendering method)
  if (dx1 > dx2)
  {
    for(; sy<=y1; sy++, sx1+=dx2, sx2+=dx1)
    {
      drawHorizontalLine(sx1/1000, sy, (sx2-sx1)/1000, color);
    }
    sx2 = x1*1000;
    sy = y1;
    for(; sy<=y2; sy++, sx1+=dx2, sx2+=dx3)
    {
      drawHorizontalLine(sx1/1000, sy, (sx2-sx1)/1000, color);
    }
  }
  else
  {
    for(; sy<=y1; sy++, sx1+=dx1, sx2+=dx2)
    {
      drawHorizontalLine(sx1/1000, sy, (sx2-sx1)/1000, color);
    }
    sx1 = x1*1000;
    sy = y1;
    for(; sy<=y2; sy++, sx1+=dx3, sx2+=dx2)
    {
      drawHorizontalLine(sx1/1000, sy, (sx2-sx1)/1000, color);
    }
  }
}

uint16_t HX8347D::Color565(uint8_t r, uint8_t g, uint8_t b) {
    uint16_t c;
    c = r >> 3;
    c <<= 6;
    c |= g >> 2;
    c <<= 5;
    c |= b >> 3;

    //printf("%x\r\n", c);
    return c;
}


// draw a rectangle
void HX8347D::drawRect(uint16_t x, uint16_t y, uint16_t w, uint16_t h, 
              uint16_t color) {
  // smarter version
  drawHorizontalLine(x, y, w, color);
  drawHorizontalLine(x, y+h-1, w, color);
  drawVerticalLine(x, y, h, color);
  drawVerticalLine(x+w-1, y, h, color);
}

// draw a rounded rectangle
void HX8347D::drawRoundRect(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t r,
               uint16_t color) {
  // smarter version
  drawHorizontalLine(x+r, y, w-2*r, color);
  drawHorizontalLine(x+r, y+h-1, w-2*r, color);
  drawVerticalLine(x, y+r, h-2*r, color);
  drawVerticalLine(x+w-1, y+r, h-2*r, color);
  // draw four corners
  drawCircleHelper(x+r, y+r, r, 1, color);
  drawCircleHelper(x+w-r-1, y+r, r, 2, color);
  drawCircleHelper(x+w-r-1, y+h-r-1, r, 4, color);
  drawCircleHelper(x+r, y+h-r-1, r, 8, color);
}


// fill a rounded rectangle
void HX8347D::fillRoundRect(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t r,
               uint16_t color) {
  // smarter version
  fillRect(x+r, y, w-2*r, h, color);

  // draw four corners
  fillCircleHelper(x+w-r-1, y+r, r, 1, h-2*r-1, color);
  fillCircleHelper(x+r, y+r, r, 2, h-2*r-1, color);
}

// fill a circle
void HX8347D::fillCircle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t color) {
  //writeRegister(TFTLCD_ENTRY_MOD, 0x1030);
  drawVerticalLine(x0, y0-r, 2*r+1, color);
  fillCircleHelper(x0, y0, r, 3, 0, color);
}


// used to do circles and roundrects!
void HX8347D::fillCircleHelper(uint16_t x0, uint16_t y0, uint16_t r, uint8_t cornername, uint16_t delta,
            uint16_t color) {

  int16_t f = 1 - r;
  int16_t ddF_x = 1;
  int16_t ddF_y = -2 * r;
  int16_t x = 0;
  int16_t y = r;

  while (x<y) {
    if (f >= 0) {
      y--;
      ddF_y += 2;
      f += ddF_y;
    }
    x++;
    ddF_x += 2;
    f += ddF_x;
  
    if (cornername & 0x1) {
      drawVerticalLine(x0+x, y0-y, 2*y+1+delta, color);
      drawVerticalLine(x0+y, y0-x, 2*x+1+delta, color);
    }
    if (cornername & 0x2) {
      drawVerticalLine(x0-x, y0-y, 2*y+1+delta, color);
      drawVerticalLine(x0-y, y0-x, 2*x+1+delta, color);
    }
  }
}


// draw a circle outline

void HX8347D::drawCircle(uint16_t x0, uint16_t y0, uint16_t r, 
            uint16_t color) {
  drawPixel(x0, y0+r, color);
  drawPixel(x0, y0-r, color);
  drawPixel(x0+r, y0, color);
  drawPixel(x0-r, y0, color);

  drawCircleHelper(x0, y0, r, 0xF, color);
}

void HX8347D::drawCircleHelper(uint16_t x0, uint16_t y0, uint16_t r, uint8_t cornername,
            uint16_t color) {
  int16_t f = 1 - r;
  int16_t ddF_x = 1;
  int16_t ddF_y = -2 * r;
  int16_t x = 0;
  int16_t y = r;


  while (x<y) {
    if (f >= 0) {
      y--;
      ddF_y += 2;
      f += ddF_y;
    }
    x++;
    ddF_x += 2;
    f += ddF_x;
    if (cornername & 0x4) {
      drawPixel(x0 + x, y0 + y, color);
      drawPixel(x0 + y, y0 + x, color);
    } 
    if (cornername & 0x2) {
      drawPixel(x0 + x, y0 - y, color);
      drawPixel(x0 + y, y0 - x, color);
    }
    if (cornername & 0x8) {
      drawPixel(x0 - y, y0 + x, color);
      drawPixel(x0 - x, y0 + y, color);
    }
    if (cornername & 0x1) {
      drawPixel(x0 - y, y0 - x, color);
      drawPixel(x0 - x, y0 - y, color);
    }
  }
}

// fill a rectangle
void HX8347D::fillRect(uint16_t x, uint16_t y, uint16_t w, uint16_t h, 
              uint16_t fillcolor) {
  // smarter version
  while (h--)
    drawHorizontalLine(x, y++, w, fillcolor);
}


void HX8347D::drawVerticalLine(uint16_t x, uint16_t y, uint16_t length, uint16_t color)
{
  if (x >= _width) return;

  drawFastLine(x,y,length,color,1);
  //drawLine(x, y, x, y+length, color);
}

void HX8347D::drawHorizontalLine(uint16_t x, uint16_t y, uint16_t length, uint16_t color)
{
  if (y >= _height) return;
  drawFastLine(x,y,length,color,0);
  //drawLine(x, y, x+length, y, color);
}


void HX8347D::setRotation(uint8_t x) {

    x %= 4;  // cant be higher than 3
    rotation = x;
    switch (x) {
    case 0:
        writeRegister(HX8347D_MEM_ACC_CTRL, 0x08); //0x1030
        _width = TFTWIDTH; 
        _height = TFTHEIGHT;
        break;
    case 1:
        writeRegister(HX8347D_MEM_ACC_CTRL, 0x68); //0x01028
        _width = TFTHEIGHT; 
        _height = TFTWIDTH;
        break;
    case 2:
        writeRegister(HX8347D_MEM_ACC_CTRL, 0xC8); //0x1000
        _width = TFTWIDTH; 
        _height = TFTHEIGHT;
        break;
    case 3:
         writeRegister(HX8347D_MEM_ACC_CTRL, 0xA8 ); //0x1018
        _width = TFTHEIGHT; 
        _height = TFTWIDTH;
        break;
    }
    //setDefaultViewport();
}

void HX8347D::drawFastLine(uint16_t x, uint16_t y, uint16_t length, 
              uint16_t color, uint8_t rotflag)
{
    uint16_t x1 = width() - 1;
    uint16_t y1 = height() - 1;
    switch (rotation) {
        case 0:
            x = x;
            y = y;
            if (rotflag) {
                x1 = x;
                y1 = y + length;
            }
            else {
                x1 = x + length;
                y1 = y;
            }
            break;
        case 1:
            x = x;
            y = y;
            if (rotflag) {
                x1 = x;
                y1 = y + length;
            }
            else {
                x1 = x + length;
                y1 = y;
            }
            break;
        case 2:
            x = x;
            y = y;
            if (rotflag) {
                x1 = x;
                y1 = y + length;
            }
            else {
                x1 = x + length;
                y1 = y;
            }
            break;
        case 3:
            x = x;
            y = y;
            if (rotflag) {
                x1 = x;
                y1 = y + length;
            }
            else {
                x1 = x + length;
                y1 = y;
            }
            //swap(x, x1)
            break;
    }
    if (x1 >= width()) {
        x1 = width() - 1;
    }
    if (y1 >= height()) {
        y1 = height() - 1;
    }

    writeRegister(HX8347D_COL_AD_START2,x>>8);
    writeRegister(HX8347D_COL_AD_START1,x);     
    writeRegister(HX8347D_COL_AD_END2,x1>>8); 
    writeRegister(HX8347D_COL_AD_END1,x1); 
    writeRegister(HX8347D_ROW_AD_START2,y>>8);
    writeRegister(HX8347D_ROW_AD_START1,y);     
    writeRegister(HX8347D_ROW_AD_END2,y1>>8); 
    writeRegister(HX8347D_ROW_AD_END1,y1); 

    writeCommand(HX8347D_SRAM_WR_CTRL);  // Write Data to GRAM (R22h)


  setWriteDir();
  _cs = 0;
  //digitalWrite(_cs, LOW);
  _rs = 1;
  //digitalWrite(_cd, HIGH);
  _rd = 1;
  //digitalWrite(_rd, HIGH);
  _wr = 1;
  //digitalWrite(_wr, HIGH);

  while (length--) {
    writeData_unsafe(color); 
  }

  // set back to default
  _cs = 1;
  //digitalWrite(_cs, HIGH);

}


void HX8347D::drawLine(int16_t x0, int16_t y0, int16_t x1, int16_t y1, 
              uint16_t color) {
  // if you're in rotation 1 or 3, we need to swap the X and Y's

  int16_t steep = abs(y1 - y0) > abs(x1 - x0);
  if (steep) {
    swap(x0, y0);
    swap(x1, y1);
  }

  if (x0 > x1) {
    swap(x0, x1);
    swap(y0, y1);
  }

  int16_t dx, dy;
  dx = x1 - x0;
  //dy = abs(y1 - y0);
  dy = abs(y1 - y0);

  int16_t err = dx / 2;
  int16_t ystep;

  if (y0 < y1) {
    ystep = 1;
  } else {
    ystep = -1;}

  for (; x0<=x1; x0++) {
    if (steep) {
      drawPixel(y0, x0, color);
    } else {
      drawPixel(x0, y0, color);
    }
    err -= dy;
    if (err < 0) {
      y0 += ystep;
      err += dx;
    }
  }
}




void HX8347D::fillScreen(uint16_t color) {
    goHome();
    uint32_t i;
    i = 320;
    i *= 240;
    _cs = 0;
    _rs = 1;
    _rd = 1;
    _wr = 1;
    setWriteDir();
    while (i--) {
        writeData_unsafe(color); 
    }
    _cs = 1;
}

void HX8347D::drawPixel(uint16_t x, uint16_t y, uint16_t color)
{
    writeRegister(HX8347D_COL_AD_START2,x>>8);
    writeRegister(HX8347D_COL_AD_START1,x);     
    writeRegister(HX8347D_COL_AD_END2,x>>8); 
    writeRegister(HX8347D_COL_AD_END1,x); 
    writeRegister(HX8347D_ROW_AD_START2,y>>8);
    writeRegister(HX8347D_ROW_AD_START1,y);     
    writeRegister(HX8347D_ROW_AD_END2,y>>8); 
    writeRegister(HX8347D_ROW_AD_END1,y); 

    writeCommand(HX8347D_SRAM_WR_CTRL);  // Write Data to GRAM (R22h)
    writeData(color);

}


static const uint16_t _regValues[] = {
    //HX8347D_CM22()
    0x002E,0x0079, //
    0x00EE,0x000C, //
    //Driving ability Setting
    0x00EA,0x0000, //PTBA[15:8]
    0x00EB,0x0020, //PTBA[7:0]
    0x00EC,0x0008, //STBA[15:8]
    0x00ED,0x00C4, //STBA[7:0]
    0x00E8,0x0040, //OPON[7:0]
    0x00E9,0x0038, //OPON1[7:0]
    0x00F1,0x0001, //OTPS1B
    0x00F2,0x0010, //GEN
    0x0027,0x00A3, //
    //Gamma 2.2 Setting
    0x0040,0x0000, //
    0x0041,0x0000, //
    0x0042,0x0001, //
    0x0043,0x0012, //
    0x0044,0x0010, //
    0x0045,0x0026, //
    0x0046,0x0008, //
    0x0047,0x0053, //
    0x0048,0x0002, //
    0x0049,0x0015, //
    0x004A,0x0019, //
    0x004B,0x0019, //
    0x004C,0x0016, //
    0x0050,0x0019, //
    0x0051,0x002F, //
    0x0052,0x002D, //
    0x0053,0x003E, //
    0x0054,0x003F, //
    0x0055,0x003F, //
    0x0056,0x002C, //
    0x0057,0x0077, //
    0x0058,0x0009, //
    0x0059,0x0006, //
    0x005A,0x0006, //
    0x005B,0x000A, //
    0x005C,0x001D, //
    0x005D,0x00CC, //
    //Power Voltage Setting
    0x001B,0x001B, //VRH=4.65V
    0x001A,0x0001, //BT (VGH~15V);(VGL~-10V);(DDVDH~5V)
    0x0024,0x002F, //VMH(VCOM High voltage ~3.2V)
    0x0025,0x0057, //VML(VCOM Low voltage -1.2V)
    //****VCOM offset**///
    0x0023,0x0097, //for Flicker adjust //can reload from OTP
    //Power on Setting
    0x0018,0x0036, //I/P_RADJ);(N/P_RADJ);( Normal mode 75Hz
    0x0019,0x0001, //OSC_EN='1');( start Osc
    0x0001,0x0000, //DP_STB='0');( out deep sleep
    0x001F,0x0088,// GAS=1);( VOMG=00);( PON=0);( DK=1);( XDK=0)
    
    0xF0,5,
    0x001F,0x0080,// GAS=1);( VOMG=00);( PON=0);( DK=0);( XDK=0);( 
    
    0xF0,5,
    0x001F,0x0090,// GAS=1);( VOMG=00);( PON=1);( DK=0);( XDK=0);( 
    
    0xF0,5,
    0x001F,0x00D0,// GAS=1);( VOMG=10);( PON=1);( DK=0);( XDK=0);( 
    
    0xF0,5,
    //262k/65k color selection
    0x0017,0x0005, //default 0x0006 262k color // 0x0005 65k color
    //SET PANEL
    0x0036,0x0000, //SS_P);( GS_P);(REV_P);(BGR_P
    //Display ON Setting
    0x0028,0x0038, //GON=1);( DTE=1);( D=1000
    0xF0,40,
    0x0028,0x003C, //GON=1);( DTE=1);( D=1100
    //
    0x0016, 0x0008,
    //Set GRAM Area
    0x0002,0x0000,
    0x0003,0x0000, //Column Start
    0x0004,0x0000,
    0x0005,0x00EF, //Column End
    0x0006,0x0000,
    0x0007,0x0000, //Row Start
    0x0008,0x0001,
    0x0009,0x003F, //Row End
    0xF1, 0x0022, //Start GRAM write
};

void HX8347D::initDisplay(void) {
    uint16_t a, d;
    reset();
    for (uint8_t i = 0; i < sizeof(_regValues) / 4; i++) {
        a = _regValues[i*2];
        d = _regValues[i*2 + 1];
        if (a == 0xF0) { // _delay
            _delay(d);
        } else if (a== 0xF1) { // write command
            writeCommand(d);
        } else
        {
            writeRegister(a, d);
        }
    }
}

uint8_t HX8347D::getRotation(void) {
  return rotation;
}


void HX8347D::BlockWrite(uint16_t Xstart,uint16_t Xend,uint16_t Ystart,uint16_t Yend)
{
    
    writeRegister(HX8347D_COL_AD_START2,Xstart>>8);     
    writeRegister(HX8347D_COL_AD_START1,Xstart);     
    writeRegister(HX8347D_COL_AD_END2,Xend>>8); 
    writeRegister(HX8347D_COL_AD_END1,Xend); 
    
    writeRegister(HX8347D_ROW_AD_START2,Ystart>>8); 
    writeRegister(HX8347D_ROW_AD_START1,Ystart);
    writeRegister(HX8347D_ROW_AD_END2,Yend>>8); 
    writeRegister(HX8347D_ROW_AD_END1,Yend);  

    writeCommand(HX8347D_SRAM_WR_CTRL);  // write ram
}
void HX8347D::DispColor(uint16_t color)
{
    uint16_t i,j;

    BlockWrite(0,TFTWIDTH-1,0,TFTHEIGHT-1);// #define ROW  320  #define COL 240

    _cs=0; 
    _rs=1;
    _rd=1;

    for(i=0;i<TFTHEIGHT;i++)
    {
        for(j=0;j<TFTWIDTH;j++)
        {    
            writeData_unsafe(color); 
        }
    }

    _cs=1; 
}

void HX8347D::reset(void)
{
    _rst=0;
    _delay(1000);
    _rst=1;
    _delay(1000);
 }
 
 void HX8347D::setWriteDir(void) {
        _d.output();
}

void HX8347D::setReadDir(void) {
        _d.input();
}

void HX8347D::write8(uint8_t d) {
    _d = d;
}
uint8_t HX8347D::read8(void) {
    return _d;
}

void HX8347D::_write(uint16_t rs, uint16_t d) {
    _cs=0;
    _rd=1;
    _rs=rs;   

    _d.output();
    _d=d>>8; 
    _wr=0;
    _delay(1);
    _wr=1;

    _d=d;
    _wr=0;
    _delay(1);
    _wr=1;

    _cs=1; 
}

void HX8347D::writeData_unsafe(uint16_t d)
{
    //_d.output();
    _d = d >> 8;

    _wr = 0;
    _delay(1);
    _wr = 1;
    
    _d = d;

    _wr = 0;
    _delay(1);
    _wr = 1;
}

uint16_t HX8347D::readData(){
    uint16_t d = 0;
    _d.input();
    _cs = 0;
    _rs = 1;
    _wr = 1;
    _rd = 1;

    //wait_us(1);
    //_rd = 0;
    //wait_us(10);
    //d = _d;
    //d <<= 8;
    //_rd = 1;

    _delay(1);
    _rd = 0;
    _delay(10);
    d = _d;
    d <<= 8;
    _rd = 1;

    _delay(1);
    _rd = 0;
    _delay(10);
    d |= _d;
    _rd = 1;
    _cs = 1;
    return d;
}


/************************************* medium level data reading/writing */

uint16_t HX8347D::readRegister(uint16_t addr) {
   writeCommand(addr);
   return readData();
}
void HX8347D::writeRegister(uint16_t addr, uint16_t data) {
   writeCommand(addr);
   writeData(data);
}

void HX8347D::goTo(uint16_t x, uint16_t y) {
    uint16_t x1 = width() - 1;
    uint16_t y1 = height() - 1;
    //calcGRAMPosition(&x, &y);
    //writeRegister(TFTLCD_GRAM_HOR_AD, x); // GRAM Address Set (Horizontal Address) (R20h)
    writeRegister(HX8347D_COL_AD_START2,x>>8);
    writeRegister(HX8347D_COL_AD_START1,x);     
    writeRegister(HX8347D_COL_AD_END2,x1>>8); 
    writeRegister(HX8347D_COL_AD_END1,x1); 
    writeRegister(HX8347D_ROW_AD_START2,y>>8);
    writeRegister(HX8347D_ROW_AD_START1,y);     
    writeRegister(HX8347D_ROW_AD_END2,y1>>8); 
    writeRegister(HX8347D_ROW_AD_END1,y1); 
    writeCommand(HX8347D_SRAM_WR_CTRL);  // write ram
}


void HX8347D::setDefaultViewport()
{
    uint16_t x1 = width() - 1;
    uint16_t y1 = height() - 1;
    writeRegister(HX8347D_COL_AD_START2,0);
    writeRegister(HX8347D_COL_AD_START1,0);     
    writeRegister(HX8347D_COL_AD_END2,x1>>8); 
    writeRegister(HX8347D_COL_AD_END1,x1); 
    writeRegister(HX8347D_ROW_AD_START2,0);
    writeRegister(HX8347D_ROW_AD_START1,0);     
    writeRegister(HX8347D_ROW_AD_END2,y1>>8); 
    writeRegister(HX8347D_ROW_AD_END1,y1); 
}

void HX8347D::getViewport(uint16_t *bx, uint16_t *by, uint16_t *ex, uint16_t *ey)
{
    *bx = readRegister(HX8347D_COL_AD_START2)<<8;    
    *bx |= readRegister(HX8347D_COL_AD_START1);    
    *ex = readRegister(HX8347D_COL_AD_END2)<<8;    
    *ex |= readRegister(HX8347D_COL_AD_END1);    
    *by = readRegister(HX8347D_ROW_AD_START2)<<8;     
    *by |= readRegister(HX8347D_ROW_AD_START1);     
    *ey = readRegister(HX8347D_ROW_AD_END2)<<8;     
    *ey |= readRegister(HX8347D_ROW_AD_END1);     
}

void HX8347D::setViewport(uint16_t bx, uint16_t by, uint16_t ex, uint16_t ey)
{
    calcGRAMPosition(&bx, &by);
    calcGRAMPosition(&ex, &ey);
    
    // Fix coordinates to be in order
    if( ey < by )
        swap(ey, by);
    if( ex < bx )
        swap(ex, bx);
    
    writeRegister(HX8347D_COL_AD_START2,bx>>8);
    writeRegister(HX8347D_COL_AD_START1,bx);     
    writeRegister(HX8347D_COL_AD_END2,ex>>8); 
    writeRegister(HX8347D_COL_AD_END1,ex); 
    writeRegister(HX8347D_ROW_AD_START2,by>>8);
    writeRegister(HX8347D_ROW_AD_START1,by);     
    writeRegister(HX8347D_ROW_AD_END2,ey>>8); 
    writeRegister(HX8347D_ROW_AD_END1,ey); 
}

void HX8347D::calcGRAMPosition(uint16_t *posx, uint16_t *posy)
{
  uint16_t x = *posx;
  uint16_t y = *posy;
  switch( rotation )
  {
      case 0:
      x = X(x);
      y = Y(y);
      break;
      case 1:  // 90
      swap(x, y);
      x = I_X(x);
      y = Y(y);
      break;
      case 2:  // 180
      x = I_X(x);
      y = I_Y(y);
      break;
      case 3: // 270
      swap(x, y);
      y = I_Y(y);
      break;
  }
  *posx = x;
  *posy = y;
}

void HX8347D::_delay(uint16_t t)
{
}
 