/*

reference
https://github.com/yamsam/TFTLCD_ST7781
https://learn.adafruit.com/2-8-tft-touchscreen/downloads
https://github.com/adafruit/TFTLCD-Library


*/
#ifndef MBED_HX8347D_H
#define MBED_HX8347D_H
// register names from Peter Barrett's Microtouch code
#include "mbed.h"

#define HX8347D_COL_AD_START2   0x02
#define HX8347D_COL_AD_START1   0x03
#define HX8347D_COL_AD_END2     0x04
#define HX8347D_COL_AD_END1     0x05
#define HX8347D_ROW_AD_START2   0x06
#define HX8347D_ROW_AD_START1   0x07
#define HX8347D_ROW_AD_END2     0x08
#define HX8347D_ROW_AD_END1     0x09
#define HX8347D_MEM_ACC_CTRL    0x16
#define HX8347D_SRAM_WR_CTRL    0x22

#define swap(a, b) { int16_t t = a; a = b; b = t; }

class HX8347D
{
public:
    HX8347D(
    PinName rd, PinName wr, PinName rs, PinName cs, PinName rst,
    PinName d0, PinName d1, PinName d2, PinName d3,
    PinName d4, PinName d5, PinName d6, PinName d7
    );
    ~HX8347D(){};

    size_t println(char *c); 

    uint16_t Color565(uint8_t r, uint8_t g, uint8_t b);

    // drawing primitives!
    void drawPixel(uint16_t x, uint16_t y, uint16_t color);
    void fillScreen(uint16_t color);
    void drawLine(int16_t x0, int16_t y0, int16_t x1, int16_t y1, uint16_t color);
    void drawFastLine(uint16_t x0, uint16_t y0, uint16_t l, uint16_t color, uint8_t flag);
    void drawVerticalLine(uint16_t x0, uint16_t y0, uint16_t length, uint16_t color);
    void drawHorizontalLine(uint16_t x0, uint16_t y0, uint16_t length, uint16_t color);
    void drawTriangle(uint16_t x0, uint16_t y0,
              uint16_t x1, uint16_t y1,
              uint16_t x2, uint16_t y2, uint16_t color);
    void fillTriangle(int32_t x0, int32_t y0,
              int32_t x1, int32_t y1,
            int32_t x2, int32_t y2, 
            uint16_t color);

    void drawRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t color);

    void fillRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t color);
    void drawRoundRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t radius, uint16_t color);
    void fillRoundRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t radius, uint16_t color);
    void drawCircle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t color);
    void fillCircle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t color);

    void setCursor(uint16_t x, uint16_t y);
    void setTextColor(uint16_t c);
    void setTextSize(uint8_t s);
    virtual size_t write(uint8_t);

    void drawChar(uint16_t x, uint16_t y, char c, uint16_t color, uint8_t s = 1);
    void drawString(uint16_t x, uint16_t y, char *c, uint16_t color, uint8_t s = 1);

    // commands
    void initDisplay(void);
    void goHome(void);
    void goTo(uint16_t x, uint16_t y);
    void reset(void);
    void setRotation(uint8_t x);
    uint8_t getRotation();
    
    void BlockWrite(uint16_t Xstart,uint16_t Xend,uint16_t Ystart,uint16_t Yend);
    void DispColor(uint16_t color);
    
    // low level
    void writeData(uint16_t data) {
        _write(1, data);
    };
    void writeCommand(uint16_t data) {
        _write(0, data);
    };

    uint16_t readData(void);
    uint16_t readRegister(uint16_t addr);
    void writeRegister(uint16_t addr, uint16_t data);

    uint16_t width();
    uint16_t height();
    static const uint16_t TFTWIDTH = 240;
    static const uint16_t TFTHEIGHT = 320;
    
    void writeData_unsafe(uint16_t d);

    void setWriteDir(void);
    void setReadDir(void);

    void write8(uint8_t d);

    void calcGRAMPosition(uint16_t *posx, uint16_t *posy);
    void getViewport(uint16_t *bx, uint16_t *by, uint16_t *ex, uint16_t *ey);
    void setViewport(uint16_t bx, uint16_t by, uint16_t ex, uint16_t ey);
    void setDefaultViewport();

private:
    void drawCircleHelper(uint16_t x0, uint16_t y0, uint16_t r, uint8_t corner, uint16_t color);
    void fillCircleHelper(uint16_t x0, uint16_t y0, uint16_t r, uint8_t corner, uint16_t delta, uint16_t color);
    uint8_t read8(void);

    DigitalOut _rd, _wr, _rs, _cs, _rst;
    BusInOut  _d;

    void _write(uint16_t rs, uint16_t d);
    uint16_t _width, _height;
    uint8_t textsize;
    uint16_t cursor_x, cursor_y;
    uint16_t textcolor;
    uint8_t rotation;
    void _delay(uint16_t t);
    
};
#endif