/* HT1621 - Holtek RAM Mapping 32x4 LCD Controller */
/**
 * TEST
 * TS119-3
 * TS119-5  http://www.aitendo.com/product/5152
 * TS174    http://www.aitendo.com/product/5153
 * http://www.holtek.com.tw/documents/10179/a33bf4b4-f0ef-4b77-94e4-3dd5d0c35f16
 * 
 * HT1621 Library
 * https://storage.googleapis.com/google-code-archive-source/v2/code.google.com/wirejungle/source-archive.zip
 * 
 * reference
 * http://jr4pdp.blog.enjoy.jp/myblog/2016/01/lcd-ts174nblpic-da92.html
 * http://morecatlab.akiba.coocan.jp/lab/index.php/2015/10/segment-lcd/
*/
#ifndef MBED_HT1621_H
#define MBED_HT1621_H
#include "mbed.h"

class HT1621 {
public:
    enum {
        SYS_DIS   = 0b00000000,
        SYS_EN    = 0b00000001,
        LCD_OFF   = 0b00000010,
        LCD_ON    = 0b00000011,
        TIMER_DIS = 0b00000100,
        WDT_DIS   = 0b00000101,
        TIMER_EN  = 0b00000110,
        WDT_EN    = 0b00000111,
        TONE_OFF  = 0b00001000,
        TONE_ON   = 0b00001001,
        
        //Set bias to 1/2 or 1/3 cycle
        //Set to 2,3 or 4 connected COM lines
        BIAS_HALF_2_COM  = 0b00100000,
        BIAS_HALF_3_COM  = 0b00100100,
        BIAS_HALF_4_COM  = 0b00101000,
        BIAS_THIRD_2_COM = 0b00100001,
        BIAS_THIRD_3_COM = 0b00100101,
        BIAS_THIRD_4_COM = 0b00101001,
        
        //Don't use
        TEST_ON   = 0b11100000,
        TEST_OFF  = 0b11100011
    } Commands;

    HT1621(
        PinName data, PinName wr, PinName rd, PinName cs
        );
    ~HT1621(){}


    void sendCommand(uint8_t cmd, bool first = true, bool last = true);

    void write(uint8_t address, uint8_t *data, uint8_t cnt);
    void read(uint8_t address, uint8_t *data, uint8_t cnt);

    void writeMem(uint8_t address, uint8_t data);
    uint8_t readMem(uint8_t address);

    void memset(uint8_t address, uint8_t data, uint8_t cnt);

private:
    DigitalInOut _data;
    DigitalOut _wr, _rd, _cs;
    void writeBits(uint8_t data, uint8_t cnt);
    uint8_t readBits(uint8_t cnt);

    inline void initControlBus();
    inline bool testMem();
    
};

#endif //HT1621_H
